/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.net.URI;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.java.truevfs.access.TPath;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.Converter;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.vfs.VfsException;
import org.xwiki.vfs.VfsPathFactory;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Singleton
public class DefaultVfsPathFactory
implements VfsPathFactory {
    @Inject
    private VfsPermissionChecker permissionChecker;
    @Inject
    private Converter<VfsResourceReference> vfsResourceReferenceConverter;
    @Inject
    @Named(value="truevfs")
    private ResourceReferenceSerializer<VfsResourceReference, URI> trueVfsResourceReferenceSerializer;

    @Override
    public Path create(URI uri) throws VfsException {
        try {
            VfsResourceReference reference = (VfsResourceReference)((Object)this.vfsResourceReferenceConverter.convert(VfsResourceReference.class, (Object)uri.toString()));
            this.permissionChecker.checkPermission(reference);
            URI trueVFSURI = (URI)this.trueVfsResourceReferenceSerializer.serialize((ResourceReference)reference);
            return new TPath(trueVFSURI);
        }
        catch (Exception e) {
            throw new VfsException(String.format("Failed to create Path instance for [%s]", uri.toString()), e);
        }
    }
}

