/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.lang.reflect.Type;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Named(value="truevfs")
@Singleton
public class URIVfsResourceReferenceSerializer
implements ResourceReferenceSerializer<VfsResourceReference, URI> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public URI serialize(VfsResourceReference reference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        URI resultURI;
        try {
            ResourceReferenceSerializer serializer = (ResourceReferenceSerializer)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceSerializer.class, new Type[]{VfsResourceReference.class, URI.class}), String.format("truevfs/%s", reference.getURI().getScheme()));
            resultURI = (URI)serializer.serialize((ResourceReference)reference);
        }
        catch (ComponentLookupException e) {
            resultURI = reference.toURI();
        }
        return resultURI;
    }
}

