/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.java.truevfs.access.TPath;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.resource.annotations.Authenticate;
import org.xwiki.vfs.VfsPermissionChecker;
import org.xwiki.vfs.VfsResourceReference;
import org.xwiki.vfs.internal.AbstractContentResourceReferenceHandler;

@Component
@Named(value="vfs")
@Singleton
@Authenticate
public class VfsResourceReferenceHandler
extends AbstractContentResourceReferenceHandler {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="cascading")
    private VfsPermissionChecker permissionChecker;
    @Inject
    @Named(value="truevfs")
    private ResourceReferenceSerializer<VfsResourceReference, URI> trueVfsResourceReferenceSerializer;

    public List<ResourceType> getSupportedResourceReferences() {
        return Arrays.asList(VfsResourceReference.TYPE);
    }

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        VfsResourceReference vfsResourceReference = (VfsResourceReference)resourceReference;
        try {
            this.permissionChecker.checkPermission(vfsResourceReference);
            URI trueVFSURI = this.convertResourceReference(vfsResourceReference);
            TPath path = new TPath(trueVFSURI);
            try (InputStream in = Files.newInputStream((Path)path, new OpenOption[0]);){
                List<String> pathSegments = vfsResourceReference.getPathSegments();
                this.serveResource(pathSegments.get(pathSegments.size() - 1), in);
            }
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to extract resource [%s]", new Object[]{vfsResourceReference}), (Throwable)e);
        }
        chain.handleNext((ResourceReference)vfsResourceReference);
    }

    private URI convertResourceReference(VfsResourceReference reference) throws ResourceReferenceHandlerException {
        URI resultURI;
        try {
            resultURI = (URI)this.trueVfsResourceReferenceSerializer.serialize((ResourceReference)reference);
        }
        catch (SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to convert VFS URI [%s] into a valid FS format", new Object[]{reference}), e);
        }
        return resultURI;
    }
}

