/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.attach;

import java.io.IOException;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputSocket;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAbstractController;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsReadOnlyFileSystemException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.vfs.internal.attach.AttachDriver;
import org.xwiki.vfs.internal.attach.AttachNode;

public class AttachController
extends FsAbstractController {
    private static final BitField<Entry.Access> READ_ONLY = BitField.of((Enum)Entry.Access.READ);
    private final AttachDriver driver;
    private ComponentManager componentManager;

    AttachController(AttachDriver driver, FsModel model, ComponentManager componentManager) {
        super(model);
        this.driver = driver;
        this.componentManager = componentManager;
    }

    private AttachNode newEntry(FsNodeName name) {
        return new AttachNode(this, name);
    }

    final FsNodePath resolve(FsNodeName name) {
        return this.getMountPoint().resolve(name);
    }

    public FsController getParent() {
        return null;
    }

    public AttachNode node(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        AttachNode entry = this.newEntry(name);
        return entry.isType(Entry.Type.FILE) ? entry : null;
    }

    public void checkAccess(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types) throws IOException {
        if (!types.isEmpty() && !READ_ONLY.equals(types)) {
            throw new FsReadOnlyFileSystemException(this.getMountPoint());
        }
    }

    public void setReadOnly(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
    }

    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types, long value) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public InputSocket<?> input(BitField<FsAccessOption> options, FsNodeName name) {
        return this.newEntry(name).input(options);
    }

    public OutputSocket<?> output(BitField<FsAccessOption> options, FsNodeName name, Entry template) {
        return this.newEntry(name).output(options, template);
    }

    public void make(BitField<FsAccessOption> options, FsNodeName name, Entry.Type type, Entry template) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public void unlink(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        throw new FsReadOnlyFileSystemException(this.getMountPoint());
    }

    public void sync(BitField<FsSyncOption> options) {
    }

    ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

