/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.attach;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.vfs.VfsResourceReference;

@Component
@Named(value="truevfs/attach")
@Singleton
public class AttachURIVfsResourceReferenceSerializer
implements ResourceReferenceSerializer<VfsResourceReference, URI> {
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> attachmentResolver;
    @Inject
    private EntityReferenceSerializer<String> documentSerializer;

    public URI serialize(VfsResourceReference reference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        AttachmentReference attachmentReference = this.attachmentResolver.resolve((Object)reference.getURI().getSchemeSpecificPart(), new Object[0]);
        String scheme = reference.getURI().getScheme();
        String documentRefefenceString = (String)this.documentSerializer.serialize((EntityReference)attachmentReference.getDocumentReference(), new Object[0]);
        return URI.create(String.format("%s://%s/%s/%s", scheme, documentRefefenceString, attachmentReference.getName(), reference.getPath()));
    }
}

