/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.vfs.internal.attach;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import javax.inject.Provider;
import net.java.truevfs.kernel.spec.FsNodeName;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.vfs.internal.attach.AttachController;

public class XWikiModelNode {
    private ComponentManager componentManager;
    private DocumentReference reference;
    private XWikiAttachment attachment;
    private XWikiContext xcontext;
    private URI uri;
    private String name;

    XWikiModelNode(AttachController controller, FsNodeName name) {
        this.name = name.toString();
        this.uri = controller.resolve(name).getUri();
        this.componentManager = controller.getComponentManager();
    }

    private ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public DocumentReference getDocumentReference() throws IOException {
        if (this.reference == null) {
            try {
                DocumentReferenceResolver documentReferenceResolver = (DocumentReferenceResolver)this.getComponentManager().getInstance((Type)DocumentReferenceResolver.TYPE_STRING);
                this.reference = documentReferenceResolver.resolve((Object)this.uri.getAuthority(), new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(String.format("Failed to compute Document reference for [%s]", this.uri), e);
            }
        }
        return this.reference;
    }

    public XWikiContext getXWikiContext() throws IOException {
        if (this.xcontext == null) {
            try {
                Provider xcontextProvider = (Provider)this.getComponentManager().getInstance((Type)XWikiContext.TYPE_PROVIDER);
                this.xcontext = (XWikiContext)xcontextProvider.get();
            }
            catch (Exception e) {
                throw new IOException(String.format("Failed to get XWiki Context for [%s]", this.uri), e);
            }
        }
        return this.xcontext;
    }

    public boolean hasAttachment() {
        boolean result;
        try {
            this.getAttachment();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public XWikiAttachment getAttachment() throws IOException {
        if (this.attachment == null) {
            try {
                XWikiDocument document = this.getXWikiContext().getWiki().getDocument(this.getDocumentReference(), this.getXWikiContext());
                this.attachment = document.getAttachment(this.name);
            }
            catch (Exception e) {
                throw new IOException(String.format("Failed to get Attachment for [%s]", this.uri), e);
            }
        }
        return this.attachment;
    }
}

