/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.HomeView;
import com.xpn.xwiki.plugin.webdav.resources.views.OrphansView;
import com.xpn.xwiki.plugin.webdav.resources.views.WhatsnewView;
import com.xpn.xwiki.plugin.webdav.resources.views.attachments.AttachmentsView;
import com.xpn.xwiki.plugin.webdav.resources.views.pages.PagesView;
import java.util.ArrayList;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(RootView.class);

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        String nextToken = tokens[next];
        boolean last = next == tokens.length - 1;
        AbstractDavView resource = null;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (last && this.getContext().isCreateOrMoveRequest()) {
            throw new DavException(405);
        }
        if (nextToken.equals("home")) {
            resource = new HomeView();
        } else if (nextToken.equals("spaces")) {
            resource = new PagesView();
        } else if (nextToken.equals("orphans")) {
            resource = new OrphansView();
        } else if (nextToken.equals("whatsnew")) {
            resource = new WhatsnewView();
        } else if (nextToken.equals("attachments")) {
            resource = new AttachmentsView();
        } else {
            throw new DavException(400);
        }
        resource.init(this, nextToken, "/" + nextToken);
        return last ? resource : resource.decode(tokens, next + 1);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            HomeView homeView = new HomeView();
            homeView.init(this, "home", "/home");
            children.add(homeView);
            PagesView pagesView = new PagesView();
            pagesView.init(this, "spaces", "/spaces");
            children.add(pagesView);
            AttachmentsView attachmentsView = new AttachmentsView();
            attachmentsView.init(this, "attachments", "/attachments");
            children.add(attachmentsView);
            OrphansView orphansView = new OrphansView();
            orphansView.init(this, "orphans", "/orphans");
            children.add(orphansView);
            WhatsnewView whatsnewView = new WhatsnewView();
            whatsnewView.init(this, "whatsnew", "/whatsnew");
            children.add(whatsnewView);
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }
}

