/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.attachments;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.attachments.AttachmentsBySpaceNameSubView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsView
extends AbstractDavView {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentsView.class);

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        boolean last;
        String nextToken = tokens[next];
        boolean bl = last = next == tokens.length - 1;
        if (this.isTempResource(nextToken)) {
            return super.decode(tokens, next);
        }
        if (!(!this.getContext().getSpaces().contains(nextToken) || last && this.getContext().isCreateOrMoveRequest())) {
            AttachmentsBySpaceNameSubView subView = new AttachmentsBySpaceNameSubView();
            subView.init(this, nextToken, "/" + nextToken);
            return last ? subView : subView.decode(tokens, next + 1);
        }
        throw new DavException(400);
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            String sql = ", XWikiAttachment as attach where doc.id = attach.docId";
            List<String> docNames = this.getContext().searchDocumentsNames(sql);
            HashSet<String> spacesWithAttachments = new HashSet<String>();
            for (String docName : docNames) {
                int dot;
                if (!this.getContext().hasAccess("view", docName) || (dot = docName.lastIndexOf(46)) == -1) continue;
                spacesWithAttachments.add(docName.substring(0, dot));
            }
            for (String spaceName : spacesWithAttachments) {
                AttachmentsBySpaceNameSubView subView = new AttachmentsBySpaceNameSubView();
                subView.init(this, spaceName, "/" + spaceName);
                children.add(subView);
            }
        }
        catch (DavException e) {
            logger.error("Unexpected Error : ", (Throwable)e);
        }
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }
}

