/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.utils;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavUserStorage;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiEngineContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;

public class XWikiDavContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiDavContext.class);
    private static Cache<XWikiDavUserStorage> davCache;
    private DavServletRequest request;
    private XWikiContext xwikiContext;
    private DavResourceFactory resourceFactory;
    private DavSession davSession;
    private LockManager lockManager;

    public XWikiDavContext(DavServletRequest request, DavServletResponse response, ServletContext servletContext, DavResourceFactory resourceFactory, DavSession davSession, LockManager lockManager) throws DavException {
        this.request = request;
        this.resourceFactory = resourceFactory;
        this.davSession = davSession;
        this.lockManager = lockManager;
        try {
            XWikiServletContext xwikiEngine = new XWikiServletContext(servletContext);
            XWikiServletRequest xwikiRequest = new XWikiServletRequest((HttpServletRequest)request);
            XWikiServletResponse xwikiResponse = new XWikiServletResponse((HttpServletResponse)response);
            this.xwikiContext = Utils.prepareContext((String)"", (XWikiRequest)xwikiRequest, (XWikiResponse)xwikiResponse, (XWikiEngineContext)xwikiEngine);
            this.xwikiContext.setMode(0);
            this.xwikiContext.setDatabase("xwiki");
            ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent(ServletContainerInitializer.class);
            containerInitializer.initializeRequest(this.xwikiContext.getRequest().getHttpServletRequest(), (Object)this.xwikiContext);
            containerInitializer.initializeResponse((HttpServletResponse)this.xwikiContext.getResponse());
            containerInitializer.initializeSession(this.xwikiContext.getRequest().getHttpServletRequest());
            containerInitializer.initializeApplicationContext(servletContext);
            XWiki xwiki = XWiki.getXWiki((XWikiContext)this.xwikiContext);
            XWikiURLFactory urlf = xwiki.getURLFactoryService().createURLFactory(this.xwikiContext.getMode(), this.xwikiContext);
            this.xwikiContext.setURLFactory(urlf);
            xwiki.prepareResources(this.xwikiContext);
            String username = "XWiki.XWikiGuest";
            XWikiUser user = this.xwikiContext.getWiki().checkAuth(this.xwikiContext);
            if (user != null) {
                username = user.getUser();
            }
            this.xwikiContext.setUser(username);
            if (this.xwikiContext.getDoc() == null) {
                this.xwikiContext.setDoc(new XWikiDocument("Fake", "Document"));
            }
            this.xwikiContext.put((Object)"ajax", (Object)Boolean.TRUE);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
        catch (ServletContainerException ex) {
            throw new DavException(500, (Throwable)ex);
        }
        if (null == davCache) {
            XWikiDavContext.initCache();
        }
    }

    private static void initCache() throws DavException {
        try {
            CacheManager cacheManager = (CacheManager)Utils.getComponent(CacheManager.class, (String)"default");
            CacheFactory factory = cacheManager.getCacheFactory();
            CacheConfiguration conf = new CacheConfiguration();
            LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
            lec.setTimeToLive(300);
            conf.put((Object)"eviction", (Object)lec);
            davCache = factory.newCache(conf);
        }
        catch (ComponentLookupException ex) {
            throw new DavException(500, (Throwable)ex);
        }
        catch (CacheException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public XWikiDavUserStorage getUserStorage() {
        String user = this.xwikiContext.getUser();
        if (null == davCache.get(user)) {
            davCache.set(user, (Object)new XWikiDavUserStorage());
        }
        return (XWikiDavUserStorage)davCache.get(user);
    }

    public boolean hasAccess(String right, String fullDocName) {
        boolean hasAccess = false;
        try {
            if (right.equals("overwrite")) {
                String overwriteAccess = this.exists(fullDocName) ? "delete" : "edit";
                hasAccess = this.hasAccess(overwriteAccess, fullDocName);
            } else if (this.xwikiContext.getWiki().getRightService().hasAccessLevel(right, this.xwikiContext.getUser(), fullDocName, this.xwikiContext)) {
                hasAccess = true;
            }
        }
        catch (XWikiException ex) {
            LOGGER.error("Error while validating access level.", (Throwable)ex);
        }
        return hasAccess;
    }

    public void checkAccess(String right, String fullDocName) throws DavException {
        if (!this.hasAccess(right, fullDocName)) {
            throw new DavException(403);
        }
    }

    public String getMimeType(XWikiAttachment attachment) {
        return attachment.getMimeType(this.xwikiContext);
    }

    public byte[] getContent(XWikiAttachment attachment) throws DavException {
        try {
            return attachment.getContent(this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public byte[] getFileContentAsBytes(InputStream in) throws DavException {
        try {
            return IOUtils.toByteArray((InputStream)in);
        }
        catch (IOException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void addAttachment(XWikiDocument doc, byte[] data, String attachmentName) throws DavException {
        String filename;
        XWikiAttachment attachment;
        int i = attachmentName.indexOf("\\");
        if (i == -1) {
            i = attachmentName.indexOf("/");
        }
        if ((attachment = doc.getAttachment(filename = attachmentName.substring(i + 1))) == null) {
            attachment = new XWikiAttachment();
            doc.getAttachmentList().add(attachment);
        }
        attachment.setContent(data);
        attachment.setFilename(filename);
        attachment.setAuthor(this.xwikiContext.getUser());
        attachment.setDoc(doc);
        doc.setAuthor(this.xwikiContext.getUser());
        if (doc.isNew()) {
            doc.setCreator(this.xwikiContext.getUser());
        }
        try {
            this.xwikiContext.getWiki().saveDocument(doc, "[WEBDAV] Attachment " + filename + " added.", this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void moveAttachment(XWikiAttachment attachment, XWikiDocument destinationDoc, String newAttachmentName) throws DavException {
        try {
            attachment.getDoc().deleteAttachment(attachment, this.xwikiContext);
            attachment.setFilename(newAttachmentName);
            destinationDoc.getAttachmentList().add(attachment);
            attachment.setDoc(destinationDoc);
            destinationDoc.saveAttachmentContent(attachment, this.xwikiContext);
            this.xwikiContext.getWiki().saveDocument(destinationDoc, "[WEBDAV] Attachment moved / renamed.", this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void deleteAttachment(XWikiAttachment attachment) throws DavException {
        try {
            attachment.getDoc().deleteAttachment(attachment, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public boolean exists(String fullDocName) {
        return this.xwikiContext.getWiki().exists(fullDocName, this.xwikiContext);
    }

    public XWikiDocument getDocument(String fullDocName) throws DavException {
        try {
            return this.xwikiContext.getWiki().getDocument(fullDocName, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public String toXML(XWikiDocument document) throws DavException {
        try {
            return document.toXML(this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void renameDocument(XWikiDocument document, String newDocumentName) throws DavException {
        if (document.isCurrentUserPage(this.xwikiContext)) {
            throw new DavException(405);
        }
        try {
            document.rename(newDocumentName, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public List<String> searchDocumentsNames(String sql) throws DavException {
        try {
            return this.xwikiContext.getWiki().getStore().searchDocumentsNames(sql, 0, 0, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public List<String> searchDocumentsNames(String sql, int nb, int start) throws DavException {
        try {
            return this.xwikiContext.getWiki().getStore().searchDocumentsNames(sql, nb, start, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public List<Object> search(String sql) throws DavException {
        try {
            return this.xwikiContext.getWiki().getStore().search(sql, 0, 0, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void saveDocument(XWikiDocument document) throws DavException {
        try {
            this.xwikiContext.getWiki().saveDocument(document, "[WEBDAV] Modified.", this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public void deleteDocument(XWikiDocument document) throws DavException {
        if (document.isCurrentUserPage(this.xwikiContext)) {
            throw new DavException(405);
        }
        try {
            this.xwikiContext.getWiki().deleteDocument(document, this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public List<String> getSpaces() throws DavException {
        try {
            return this.xwikiContext.getWiki().getSpaces(this.xwikiContext);
        }
        catch (XWikiException ex) {
            throw new DavException(500, (Throwable)ex);
        }
    }

    public boolean isCreateCollectionRequest() {
        return DavMethods.isCreateCollectionRequest((DavServletRequest)this.request);
    }

    public boolean isCreateFileRequest() {
        int methodCode = DavMethods.getMethodCode((String)this.getMethod());
        return methodCode == 6 || methodCode == 4;
    }

    public boolean isCreateResourceRequest() {
        return this.isCreateCollectionRequest() || this.isCreateFileRequest();
    }

    public boolean isMoveResourceRequest() {
        int methodCode = DavMethods.getMethodCode((String)this.getMethod());
        return methodCode == 11;
    }

    public boolean isCreateOrMoveRequest() {
        return this.isMoveResourceRequest() || this.isCreateResourceRequest();
    }

    public boolean isMoveAttachmentRequest(XWikiDocument doc) {
        int methodCode = DavMethods.getMethodCode((String)this.getMethod());
        if (methodCode == 11) {
            String rPath = this.request.getRequestLocator().getResourcePath();
            rPath = rPath.endsWith("/") ? rPath.substring(0, rPath.length() - 1) : rPath;
            String resourceName = rPath.substring(rPath.lastIndexOf("/") + 1);
            return doc.getAttachment(resourceName) != null;
        }
        return false;
    }

    public boolean isDeleteResourceRequest() {
        int methodCode = DavMethods.getMethodCode((String)this.getMethod());
        return methodCode == 5;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getUser() {
        return this.xwikiContext.getUser();
    }

    public DavResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public DavSession getDavSession() {
        return this.davSession;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public XWikiContext getXwikiContext() {
        return this.xwikiContext;
    }

    public void cleanUp() {
        if (this.xwikiContext != null && this.xwikiContext.getWiki() != null) {
            this.xwikiContext.getWiki().getStore().cleanUp(this.xwikiContext);
        }
    }
}

