/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavResource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class DavTempFile
extends AbstractDavResource {
    private boolean isCollection;
    private byte[] data;
    private boolean created;
    private Date timeOfCreation = new Date(-1L);
    private Date timeOfLastModification = (Date)this.timeOfCreation.clone();

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        String strTimeOfCreation = DavConstants.creationDateFormat.format(this.timeOfCreation);
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)strTimeOfCreation));
        String strTimeOfModification = DavConstants.modificationDateFormat.format(this.timeOfLastModification);
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)strTimeOfModification));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)strTimeOfModification));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)"en"));
        String contentType = this.isCollection() ? "text/directory" : "application/octet-stream";
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)contentType));
        int contentLength = this.data != null ? this.data.length : 0;
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)contentLength));
    }

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        return super.decode(tokens, next);
    }

    public boolean exists() {
        return this.parentResource.getVirtualMembers().contains(this);
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        outputContext.setContentLanguage("en");
        outputContext.setContentLength(this.data != null ? (long)this.data.length : 0L);
        outputContext.setContentType(this.isCollection() ? "text/directory" : "application/octet-stream");
        outputContext.setETag(DavConstants.modificationDateFormat.format(this.getModificationTime()));
        outputContext.setModificationTime(this.getModificationTime());
        if (this.exists() && !this.isCollection() && (out = outputContext.getOutputStream()) != null) {
            out.write(this.data);
            out.flush();
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        children.addAll(this.getVirtualMembers());
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        if (!(resource instanceof DavTempFile)) {
            throw new DavException(500);
        }
        this.addVirtualMember(resource, inputContext);
    }

    public void removeMember(DavResource resource) throws DavException {
        if (!(resource instanceof DavTempFile)) {
            throw new DavException(500);
        }
        this.removeVirtualMember(resource);
    }

    public void move(DavResource destination) throws DavException {
        if (!(destination instanceof DavTempFile) || !destination.getCollection().equals(this.getCollection()) || destination.isCollection() || this.isCollection()) {
            throw new DavException(403);
        }
        DavTempFile destTempFile = (DavTempFile)destination;
        this.parentResource.getVirtualMembers().remove(this);
        this.parentResource.getVirtualMembers().add(destTempFile);
        destTempFile.update((byte[])this.data.clone(), this.timeOfLastModification);
        this.clearCache();
    }

    public void update(byte[] data, Date modificationTime) {
        this.data = (byte[])data.clone();
        this.setModified(modificationTime);
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.data.length));
    }

    public void setModified(Date modificationTime) {
        if (!this.created) {
            this.timeOfCreation = (Date)modificationTime.clone();
            String strTimeOfCreation = DavConstants.creationDateFormat.format(this.timeOfCreation);
            this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)strTimeOfCreation));
            this.created = true;
        }
        this.timeOfLastModification = (Date)modificationTime.clone();
        String strTimeOfModification = DavConstants.modificationDateFormat.format(this.timeOfLastModification);
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)strTimeOfModification));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)String.valueOf(this.timeOfLastModification)));
    }

    public void setCollection() {
        this.isCollection = true;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public long getModificationTime() {
        return this.timeOfLastModification.getTime();
    }
}

