/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavFile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

public class DavWikiFile
extends AbstractDavFile {
    public static final String WIKI_TXT = "wiki.txt";
    public static final String WIKI_XML = "wiki.xml";
    private XWikiDocument parentDoc;

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!name.equals(WIKI_TXT) && !name.equals(WIKI_XML)) {
            throw new DavException(500);
        }
        this.parentDoc = ((DavPage)parent).getDocument();
        String timeStamp = DavConstants.creationDateFormat.format(this.parentDoc.getCreationDate());
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        timeStamp = DavConstants.modificationDateFormat.format(this.parentDoc.getContentUpdateDate());
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.parentDoc.getLanguage()));
        String contentType = this.name.equals(WIKI_TXT) ? "text/plain" : "text/xml";
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)contentType));
        int contentLength = this.name.equals(WIKI_TXT) ? this.parentDoc.getContent().length() : this.getContext().toXML(this.parentDoc).length();
        this.getProperties().add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)contentLength));
    }

    public boolean exists() {
        return !this.parentDoc.isNew() && this.parentResource.getVirtualMembers().contains(this);
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        if (!this.getContext().hasAccess("view", this.parentDoc.getFullName())) {
            throw new IOException("Access rights violation.");
        }
        outputContext.setContentLanguage(this.parentDoc.getLanguage());
        int contentLength = 0;
        try {
            contentLength = this.name.equals(WIKI_TXT) ? this.parentDoc.getContent().length() : this.getContext().toXML(this.parentDoc).length();
        }
        catch (DavException ex) {
            throw new IOException(ex.getMessage());
        }
        outputContext.setContentLength((long)contentLength);
        outputContext.setContentType(this.name.equals(WIKI_TXT) ? "text/plain" : "text/xml");
        outputContext.setETag(DavConstants.modificationDateFormat.format(this.getModificationTime()));
        outputContext.setModificationTime(this.getModificationTime());
        if (this.exists() && (out = outputContext.getOutputStream()) != null) {
            try {
                String content = this.name.equals(WIKI_TXT) ? this.parentDoc.getContent() : this.getContext().toXML(this.parentDoc);
                out.write(content.getBytes());
                out.flush();
            }
            catch (DavException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    public void move(DavResource destination) throws DavException {
        throw new DavException(501);
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.parentDoc.getContentUpdateDate().getTime();
        }
        return -1L;
    }
}

