/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.filesystem.FilesystemExportContext;
import org.xwiki.url.internal.RelativeExtendedURL;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Named(value="filesystem")
@Singleton
public class FilesystemResourceReferenceSerializer
implements ResourceReferenceSerializer<WebJarsResourceReference, ExtendedURL> {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars";
    private static final String WEBJAR_PATH = "webjars";
    @Inject
    private Provider<FilesystemExportContext> exportContextProvider;

    public ExtendedURL serialize(WebJarsResourceReference reference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        FilesystemExportContext exportContext = (FilesystemExportContext)this.exportContextProvider.get();
        try {
            this.copyResourceFromJAR(WEBJARS_RESOURCE_PREFIX, reference.getResourceName(), WEBJAR_PATH, exportContext);
        }
        catch (IOException e) {
            throw new SerializeResourceReferenceException(String.format("Failed to extract and copy WebJAR resource [%s]", reference.getResourceName()), (Throwable)e);
        }
        ArrayList<String> pathSegments = new ArrayList<String>();
        for (int i = 0; i < exportContext.getCSSParentLevel(); ++i) {
            pathSegments.add("..");
        }
        pathSegments.add(WEBJAR_PATH);
        for (String resourceSegment : StringUtils.split((String)reference.getResourceName(), (char)'/')) {
            pathSegments.add(resourceSegment);
        }
        return new RelativeExtendedURL(pathSegments);
    }

    private File getJARFile(String resourceName) throws IOException {
        File file;
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        JarURLConnection connection = (JarURLConnection)resourceURL.openConnection();
        URL jarURL = connection.getJarFileURL();
        try {
            file = new File(jarURL.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(jarURL.getPath());
        }
        return file;
    }

    private void copyResourceFromJAR(String resourcePrefix, String resourceName, String targetPrefix, FilesystemExportContext exportContext) throws IOException {
        String resourcePath = String.format("%s/%s", resourcePrefix, resourceName);
        JarFile jar = new JarFile(this.getJARFile(resourcePath));
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            if (!entry.getName().startsWith(resourcePath) || entry.isDirectory()) continue;
            String targetPath = targetPrefix + entry.getName().substring(resourcePrefix.length());
            File targetLocation = new File(exportContext.getExportDir(), targetPath);
            if (targetLocation.exists()) continue;
            targetLocation.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(targetLocation);
            InputStream is = jar.getInputStream(entry);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            fos.close();
            is.close();
        }
        jar.close();
    }
}

