/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.resource.AbstractResourceReference;
import org.xwiki.resource.ResourceType;

public class WebJarsResourceReference
extends AbstractResourceReference {
    public static final ResourceType TYPE = new ResourceType("webjars");
    private static final char RESOURCE_PATH_SEPARATOR = '/';
    private static final String WIKI_PARAMETER_NAME = "wiki";
    private List<String> resourceSegments;

    public WebJarsResourceReference(List<String> resourceSegments) {
        this.setType(TYPE);
        this.resourceSegments = new ArrayList<String>(resourceSegments);
    }

    public List<String> getResourceSegments() {
        return this.resourceSegments;
    }

    public String getResourceName() {
        return StringUtils.join(this.getResourceSegments(), (char)'/');
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 5).append(this.getResourceSegments()).append((Object)this.getType()).append((Object)this.getParameters()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        WebJarsResourceReference rhs = (WebJarsResourceReference)((Object)object);
        return new EqualsBuilder().append(this.getResourceSegments(), rhs.getResourceSegments()).append((Object)this.getType(), (Object)rhs.getType()).append((Object)this.getParameters(), (Object)rhs.getParameters()).isEquals();
    }

    public String getWikiId() {
        return this.getParameterValue(WIKI_PARAMETER_NAME);
    }
}

