/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.script.service.ScriptService;
import org.xwiki.url.ExtendedURL;
import org.xwiki.webjars.internal.WebJarsResourceReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="webjars")
@Singleton
public class WebJarsScriptService
implements ScriptService {
    private static final String RESOURCE_SEPARATOR = "/";
    private static final String VERSION = "version";
    private static final String WIKI = "wiki";
    private static final String DEFAULT_WEBJAR_GROUP_ID = "org.webjars";
    @Inject
    private Logger logger;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> defaultResourceReferenceSerializer;

    public String url(String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return null;
        }
        String[] parts = resourceName.split(RESOURCE_SEPARATOR, 3);
        if (parts.length < 3) {
            this.logger.warn("Invalid webjar resource name [{}]. Expected format is 'webjarId/version/path'", (Object)resourceName);
            return null;
        }
        return this.url("fakeGroupId:" + parts[0], parts[2], Collections.singletonMap(VERSION, parts[1]));
    }

    public String url(String webjarId, String path) {
        return this.url(webjarId, path, null);
    }

    public String url(String webjarId, String path, Map<String, ?> params) {
        ExtendedURL extendedURL;
        if (StringUtils.isEmpty((CharSequence)webjarId)) {
            return null;
        }
        String groupId = DEFAULT_WEBJAR_GROUP_ID;
        String artifactId = webjarId;
        int groupSeparatorPosition = webjarId.indexOf(58);
        if (groupSeparatorPosition >= 0) {
            groupId = webjarId.substring(0, groupSeparatorPosition);
            artifactId = webjarId.substring(groupSeparatorPosition + 1);
        }
        LinkedHashMap<String, Object> urlParams = new LinkedHashMap<String, Object>();
        if (params != null) {
            urlParams.putAll(params);
        }
        String wikiId = (String)urlParams.get(WIKI);
        Object version = urlParams.remove(VERSION);
        if (version == null) {
            version = this.getVersion(String.format("%s:%s", groupId, artifactId), wikiId);
        }
        WebJarsResourceReference resourceReference = this.getResourceReference(artifactId, version, path, urlParams);
        try {
            extendedURL = (ExtendedURL)this.defaultResourceReferenceSerializer.serialize((ResourceReference)resourceReference);
        }
        catch (SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
            this.logger.warn("Error while serializing WebJar URL for id [{}], path = [{}]. Root cause = [{}]", new Object[]{webjarId, path, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return null;
        }
        return extendedURL.serialize();
    }

    private WebJarsResourceReference getResourceReference(String artifactId, Object version, String path, Map<String, Object> urlParams) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(artifactId);
        if (version != null) {
            segments.add((String)version);
        }
        segments.addAll(Arrays.asList(path.split(RESOURCE_SEPARATOR)));
        if (path.endsWith(".js") && urlParams.isEmpty()) {
            urlParams.put("r", "1");
        }
        WebJarsResourceReference resourceReference = new WebJarsResourceReference(segments);
        for (Map.Entry<String, Object> parameterEntry : urlParams.entrySet()) {
            resourceReference.addParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return resourceReference;
    }

    private String getVersion(String extensionId, String wikiId) {
        CoreExtension extension = this.coreExtensionRepository.getCoreExtension(extensionId);
        if (extension == null) {
            String selectedWikiId = StringUtils.isNotEmpty((CharSequence)wikiId) ? wikiId : this.wikiDescriptorManager.getCurrentWikiId();
            String namespace = this.constructNamespace(selectedWikiId);
            extension = this.installedExtensionRepository.getInstalledExtension(extensionId, namespace);
            if (extension == null && (extension = this.installedExtensionRepository.getInstalledExtension(extensionId, namespace = this.constructNamespace(this.wikiDescriptorManager.getMainWikiId()))) == null) {
                return null;
            }
        }
        return extension.getId().getVersion().getValue();
    }

    private String constructNamespace(String wikiId) {
        return String.format("wiki:%s", wikiId);
    }
}

