/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.webjars.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.filesystem.FilesystemExportContext;
import org.xwiki.url.internal.RelativeExtendedURL;
import org.xwiki.webjars.internal.FilesystemResourceReferenceCopier;
import org.xwiki.webjars.internal.WebJarsResourceReference;

@Component
@Named(value="filesystem")
@Singleton
public class FilesystemResourceReferenceSerializer
implements ResourceReferenceSerializer<WebJarsResourceReference, ExtendedURL> {
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars";
    private static final String PARENT = "..";
    private static final String WEBJAR_PATH = "webjars";
    @Inject
    private Provider<FilesystemExportContext> exportContextProvider;

    public ExtendedURL serialize(WebJarsResourceReference reference) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        int i;
        FilesystemExportContext exportContext = (FilesystemExportContext)this.exportContextProvider.get();
        try {
            FilesystemResourceReferenceCopier copier = new FilesystemResourceReferenceCopier();
            copier.copyResourceFromJAR(WEBJARS_RESOURCE_PREFIX, reference.getResourceName(), WEBJAR_PATH, exportContext);
            if (reference.getResourceName().toLowerCase().endsWith("css")) {
                copier.processCSS(WEBJARS_RESOURCE_PREFIX, reference.getResourceName(), WEBJAR_PATH, exportContext);
            }
        }
        catch (Exception e) {
            throw new SerializeResourceReferenceException(String.format("Failed to extract and copy WebJAR resource [%s]", reference.getResourceName()), (Throwable)e);
        }
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (exportContext.getCSSParentLevel() == 0) {
            for (i = 0; i < exportContext.getDocParentLevel(); ++i) {
                pathSegments.add(PARENT);
            }
        } else {
            for (i = 0; i < exportContext.getCSSParentLevel(); ++i) {
                pathSegments.add(PARENT);
            }
        }
        pathSegments.add(WEBJAR_PATH);
        for (String resourceSegment : StringUtils.split((String)reference.getResourceName(), (char)'/')) {
            pathSegments.add(resourceSegment);
        }
        return new RelativeExtendedURL(pathSegments);
    }
}

