/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.wiki.creationjob.internal.steps;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.platform.wiki.creationjob.WikiCreationException;
import org.xwiki.platform.wiki.creationjob.WikiCreationRequest;
import org.xwiki.platform.wiki.creationjob.WikiCreationStep;
import org.xwiki.wiki.manager.WikiManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="create")
public class CreateWikiStep
implements WikiCreationStep {
    @Inject
    private WikiManager wikiManager;

    @Override
    public void execute(WikiCreationRequest request) throws WikiCreationException {
        try {
            this.wikiManager.create(request.getWikiId(), request.getAlias(), request.isFailOnExist());
        }
        catch (WikiManagerException e) {
            throw new WikiCreationException(String.format("Failed to create the wiki [%s].", request.getWikiId()), e);
        }
    }

    @Override
    public int getOrder() {
        return 1000;
    }
}

