/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.provisioning;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.provisioning.WikiCopier;

@Component
@Singleton
public class DefaultWikiCopier
implements WikiCopier {
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private JobProgressManager progress;
    @Inject
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDocuments(String fromWikiId, String toWikiId, boolean withHistory) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        this.progress.pushLevelProgress(2, (Object)this);
        try {
            this.progress.startStep((Object)this, "Get documents to copy");
            Query query = this.queryManager.createQuery("select distinct doc.fullName from Document as doc", "xwql");
            query.setWiki(fromWikiId);
            List documentFullnames = query.execute();
            this.progress.endStep((Object)this);
            this.progress.startStep((Object)this, "Copy documents");
            this.progress.pushLevelProgress(documentFullnames.size(), (Object)this);
            WikiReference fromWikiReference = new WikiReference(fromWikiId);
            try {
                for (String documentFullName : documentFullnames) {
                    this.progress.startStep((Object)this);
                    DocumentReference origDocReference = this.documentReferenceResolver.resolve((Object)documentFullName, new Object[]{fromWikiReference});
                    DocumentReference newDocReference = origDocReference.setWikiReference(new WikiReference(toWikiId));
                    this.logger.info("Copying document [{}] to [{}].", (Object)origDocReference, (Object)newDocReference);
                    xwiki.copyDocument(origDocReference, newDocReference, null, !withHistory, true, context);
                    this.logger.info("Done copying document [{}] to [{}].", (Object)origDocReference, (Object)newDocReference);
                    this.progress.endStep((Object)this);
                }
            }
            finally {
                this.progress.popLevelProgress((Object)this);
                this.progress.endStep((Object)this);
            }
        }
        catch (QueryException e) {
            WikiManagerException thrownException = new WikiManagerException("Unable to get the list of wiki documents to copy.", (Throwable)e);
            this.logger.error(thrownException.getMessage(), (Throwable)thrownException);
            throw thrownException;
        }
        catch (XWikiException e) {
            WikiManagerException thrownException = new WikiManagerException("Failed to copy documents.", (Throwable)e);
            this.logger.error(thrownException.getMessage(), (Throwable)thrownException);
            throw thrownException;
        }
        finally {
            this.progress.popLevelProgress((Object)this);
        }
    }

    public void copyDeletedDocuments(String fromWikiId, String toWikiId) throws WikiManagerException {
        throw new WikiManagerException("This method is not implemented yet");
    }
}

