/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.provisioning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.wiki.provisioning.WikiProvisioningJob;
import org.xwiki.wiki.provisioning.WikiProvisioningJobException;
import org.xwiki.wiki.provisioning.WikiProvisioningJobExecutor;
import org.xwiki.wiki.provisioning.WikiProvisioningJobRequest;

@Component
@Singleton
public class DefaultWikiProvisioningJobExecutor
implements WikiProvisioningJobExecutor,
Initializable {
    private Map<List<String>, WikiProvisioningJob> jobs;
    private ExecutorService jobExecutor;
    @Inject
    private ComponentManager componentManager;

    public void initialize() throws InitializationException {
        this.jobs = new HashMap<List<String>, WikiProvisioningJob>();
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("XWiki provisioning thread").daemon(true).priority(1).build();
        this.jobExecutor = Executors.newCachedThreadPool((ThreadFactory)factory);
    }

    public WikiProvisioningJob createAndExecuteJob(String wikiId, String provisioningJobName, Object parameter) throws WikiProvisioningJobException {
        try {
            WikiProvisioningJob job = (WikiProvisioningJob)this.componentManager.getInstance(Job.class, provisioningJobName);
            ArrayList<String> jobId = new ArrayList<String>();
            jobId.add("wiki");
            jobId.add("provisioning");
            jobId.add(provisioningJobName);
            jobId.add(wikiId);
            job.initialize((Request)new WikiProvisioningJobRequest(jobId, wikiId, parameter));
            this.jobs.put(jobId, job);
            this.jobExecutor.execute((Runnable)new ExecutionContextRunnable((Runnable)job, this.componentManager));
            return job;
        }
        catch (ComponentLookupException e) {
            throw new WikiProvisioningJobException(String.format("Failed to lookup provisioning job component for role [%s]", provisioningJobName), (Throwable)e);
        }
    }

    public WikiProvisioningJob getJob(List<String> jobId) throws WikiProvisioningJobException {
        try {
            WikiProvisioningJob job = this.jobs.get(jobId);
            return job;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new WikiProvisioningJobException(String.format("There is no job corresponding to the jobId [%d].", jobId), (Throwable)e);
        }
    }
}

