/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.listener;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.internal.descriptor.DefaultWikiDescriptor;
import org.xwiki.wiki.internal.descriptor.builder.WikiDescriptorBuilder;
import org.xwiki.wiki.internal.descriptor.document.WikiDescriptorDocumentHelper;
import org.xwiki.wiki.internal.manager.WikiDescriptorCache;

@Component
@Named(value="wikidescriptor")
@Singleton
public class WikiDescriptorListener
implements EventListener {
    static final EntityReference SERVER_CLASS = new EntityReference("XWikiServerClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    @Inject
    private WikiDescriptorBuilder builder;
    @Inject
    private WikiDescriptorCache cache;
    @Inject
    private WikiDescriptorDocumentHelper wikiDescriptorDocumentHelper;

    public String getName() {
        return "wikidescriptor";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        DefaultWikiDescriptor descriptor;
        List serverClassObjects;
        XWikiDocument document = (XWikiDocument)source;
        if (event instanceof DocumentDeletedEvent || event instanceof DocumentUpdatedEvent) {
            this.removeExistingDescriptor(document.getOriginalDocument());
        }
        if ((serverClassObjects = document.getXObjects(SERVER_CLASS)) != null && !serverClassObjects.isEmpty() && (descriptor = this.builder.buildDescriptorObject(serverClassObjects, document)) != null) {
            this.cache.add(descriptor);
        }
    }

    private void removeExistingDescriptor(XWikiDocument document) {
        String wikiId;
        DefaultWikiDescriptor existingDescriptor;
        List existingServerClassObjects = document.getXObjects(SERVER_CLASS);
        if (existingServerClassObjects != null && !existingServerClassObjects.isEmpty() && (existingDescriptor = this.cache.getFromId(wikiId = this.wikiDescriptorDocumentHelper.getWikiIdFromDocumentReference(document.getDocumentReference()))) != null) {
            this.cache.remove(existingDescriptor);
        }
    }
}

