/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.manager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.Util;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiCopiedEvent;
import org.xwiki.bridge.event.WikiCreateFailedEvent;
import org.xwiki.bridge.event.WikiCreatedEvent;
import org.xwiki.bridge.event.WikiCreatingEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.internal.manager.WikiCopier;
import org.xwiki.wiki.internal.manager.WikiCreator;
import org.xwiki.wiki.internal.manager.WikiDeleter;
import org.xwiki.wiki.manager.WikiManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultWikiManager
implements WikiManager {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private Logger logger;
    @Inject
    private WikiCreator wikiCreator;
    @Inject
    private WikiCopier wikiCopier;
    @Inject
    private WikiDeleter wikiDeleter;

    public WikiDescriptor create(String wikiId, String wikiAlias, boolean failOnExist) throws WikiManagerException {
        WikiDescriptor descriptor;
        if (failOnExist && !this.idAvailable(wikiId)) {
            throw new WikiManagerException("wiki id is not valid");
        }
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            this.observationManager.notify((Event)new WikiCreatingEvent(wikiId), (Object)wikiId, (Object)context);
            descriptor = this.wikiCreator.create(wikiId, wikiAlias);
            this.observationManager.notify((Event)new WikiCreatedEvent(wikiId), (Object)wikiId, (Object)context);
        }
        catch (WikiManagerException e) {
            this.observationManager.notify((Event)new WikiCreateFailedEvent(wikiId), (Object)wikiId, (Object)context);
            throw e;
        }
        return descriptor;
    }

    public WikiDescriptor copy(String fromWikiId, String newWikiId, String newWikiAlias, boolean copyHistory, boolean copyRecycleBin, boolean failOnExist) throws WikiManagerException {
        WikiDescriptor newWiki = this.create(newWikiId, newWikiAlias, failOnExist);
        this.wikiCopier.copyDocuments(fromWikiId, newWikiId, copyHistory);
        if (copyRecycleBin) {
            this.wikiCopier.copyDeletedDocuments(fromWikiId, newWikiId);
        }
        this.observationManager.notify((Event)new WikiCopiedEvent(fromWikiId, newWikiId), (Object)fromWikiId, this.xcontextProvider.get());
        return newWiki;
    }

    public WikiDescriptor rename(String wikiId, String newWikiId) throws WikiManagerException {
        throw new WikiManagerException("This method is not implemented yet");
    }

    public void delete(String wikiId) throws WikiManagerException {
        this.wikiDeleter.delete(wikiId);
        this.observationManager.notify((Event)new WikiDeletedEvent(wikiId), (Object)wikiId);
    }

    public boolean idAvailable(String wikiId) throws WikiManagerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String wikiForbiddenList = ((XWikiContext)this.xcontextProvider.get()).getWiki().Param("xwiki.virtual.reserved_wikis");
        try {
            return !this.wikiDescriptorManager.exists(wikiId) && !Util.contains((String)wikiId, (String)wikiForbiddenList, (String)", ") && xwiki.getStore().isWikiNameAvailable(wikiId, xcontext);
        }
        catch (XWikiException e) {
            throw new WikiManagerException("Fail to look at the databases.");
        }
    }

    private XWikiDocument getDocument(DocumentReference reference) throws WikiManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            return xwiki.getDocument(reference, context);
        }
        catch (XWikiException e) {
            throw new WikiManagerException(String.format("Failed to get document [%s] containing a XWiki.XWikiServerClass object", reference), (Throwable)e);
        }
    }
}

