/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.internal.descriptor.document;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.wiki.internal.descriptor.document.XWikiServerClassDocumentInitializer;

@Component
@Named(value="XWiki.XWikiServerXwiki")
@Singleton
public class XWikiServerXwikiDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String DOCUMENT_NAME = "XWikiServerXwiki";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private Container container;

    public XWikiServerXwikiDocumentInitializer() {
        super("XWiki", DOCUMENT_NAME);
    }

    public boolean isMainWikiOnly() {
        return true;
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        if (document.getXObject((EntityReference)XWikiServerClassDocumentInitializer.SERVER_CLASS) == null) {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            try {
                BaseObject xobject = document.newXObject((EntityReference)XWikiServerClassDocumentInitializer.SERVER_CLASS, xcontext);
                xobject.setStringValue("description", "Main wiki");
                xobject.setStringValue("homepage", "Main.WebHome");
                xobject.setStringValue("language", "en");
                xobject.setIntValue("secure", 0);
                xobject.setStringValue("state", "active");
                xobject.setStringValue("visibility", "public");
                xobject.setStringValue("owner", "XWiki.superadmin");
                xobject.setStringValue("wikiprettyname", "Home");
                Request request = this.container.getRequest();
                if (request instanceof ServletRequest) {
                    ServletRequest servletRequest = (ServletRequest)request;
                    xobject.setStringValue("server", servletRequest.getHttpServletRequest().getServerName());
                } else {
                    xobject.setStringValue("server", "localhost");
                }
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error("Faied to initialize main wiki descriptor", (Throwable)e);
            }
        }
        return needsUpdate |= this.setDocumentFields(document, "");
    }
}

