/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import com.xpn.xwiki.web.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public class Wiki
extends Document {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Wiki.class);

    public Wiki(XWikiDocument xdoc, XWikiContext context) throws XWikiException {
        super(xdoc, context);
    }

    public String getWikiName() throws XWikiException {
        return XWikiServerClass.getInstance(this.context).getItemDefaultName(this.getFullName());
    }

    public void delete(boolean deleteDatabase) throws XWikiException {
        String wikiName = this.getWikiName();
        if (wikiName.equals(this.context.getMainXWiki())) {
            throw new WikiManagerException(9001, WikiManagerMessageTool.getDefault(this.context).get("wikimanager.plugin.error.deletemainwiki", wikiName));
        }
        if (deleteDatabase) {
            if (this.hasAdminRights()) {
                try {
                    this.context.getWiki().getStore().deleteWiki(wikiName, this.context);
                }
                catch (XWikiException e) {
                    LOGGER.error("Failed to delete wiki from database", (Throwable)e);
                }
            } else {
                throw new WikiManagerException(9001, WikiManagerMessageTool.getDefault(this.context).get("wikimanager.plugin.error.righttodeletewiki", wikiName));
            }
        }
        super.delete();
        ((ObservationManager)Utils.getComponent(ObservationManager.class)).notify((Event)new WikiDeletedEvent(wikiName), (Object)wikiName, (Object)this.context);
    }

    public int countWikiAliases() throws XWikiException {
        Vector objects = this.getObjects(XWikiServerClass.getInstance(this.context).getClassFullName());
        int nb = 0;
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            if (it.next() == null) continue;
            ++nb;
        }
        return nb;
    }

    public int getWikiAliasIdFromDomain(String domain) throws XWikiException {
        Vector objects = this.doc.getObjects(XWikiServerClass.getInstance(this.context).getClassFullName());
        for (BaseObject bobect : objects) {
            if (bobect == null || !bobect.getStringValue("server").equals(domain)) continue;
            return bobect.getNumber();
        }
        throw new WikiManagerException(50041, WikiManagerMessageTool.getDefault(this.context).get("wikimanager.plugin.error.wikialiasdoesnotexists", this.getWikiName() + " - " + domain));
    }

    public Collection<XWikiServer> getWikiAliasList() throws XWikiException {
        return XWikiServerClass.getInstance(this.context).newXObjectDocumentList(this.doc, this.context);
    }

    public XWikiServer getWikiAlias(String domain) throws XWikiException {
        int id = this.getWikiAliasIdFromDomain(domain);
        return this.getWikiAlias(id);
    }

    public XWikiServer getWikiAlias(int id) throws XWikiException {
        return XWikiServerClass.getInstance(this.context).newXObjectDocument(this.doc, id, this.context);
    }

    public XWikiServer getFirstWikiAlias() throws XWikiException {
        Vector objects = this.doc.getObjects(XWikiServerClass.getInstance(this.context).getClassFullName());
        return objects != null && objects.size() > 0 ? this.getWikiAlias(((BaseObject)objects.iterator().next()).getNumber()) : null;
    }

    public boolean containsWikiAlias(String domain) {
        boolean contains = false;
        try {
            this.getWikiAliasIdFromDomain(domain);
            contains = true;
        }
        catch (XWikiException xWikiException) {
            // empty catch block
        }
        return contains;
    }

    public String toString() {
        try {
            return this.getWikiName();
        }
        catch (XWikiException e) {
            return super.toString();
        }
    }
}

