/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager.doc;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.AbstractXClassManager;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.XObjectDocumentDoesNotExistException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import java.util.List;

public class XWikiServerClass
extends AbstractXClassManager<XWikiServer> {
    public static final String DEFAULT_FIELDS = "|";
    public static final String FIELD_WIKIPRETTYNAME = "wikiprettyname";
    public static final String FIELDPN_WIKIPRETTYNAME = "Wiki pretty name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELDPN_OWNER = "Owner";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELDPN_DESCRIPTION = "Description";
    public static final String FIELD_SERVER = "server";
    public static final String FIELDPN_SERVER = "Server";
    public static final String FIELD_VISIBILITY = "visibility";
    public static final String FIELDL_VISIBILITY_PUBLIC = "public";
    public static final String FIELDL_VISIBILITY_PRIVATE = "private";
    public static final String FIELDL_VISIBILITY = "public|private|";
    public static final String FIELDPN_VISIBILITY = "Visibility";
    public static final String FIELD_STATE = "state";
    public static final String FIELDL_STATE_ACTIVE = "active";
    public static final String FIELDL_STATE_INACTIVE = "inactive";
    public static final String FIELDL_STATE_LOCKED = "locked";
    public static final String FIELDL_STATE = "active|inactive|locked";
    public static final String FIELDPN_STATE = "State";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELDL_LANGUAGE = "en|fr";
    public static final String FIELDPN_LANGUAGE = "Language";
    public static final String FIELD_SECURE = "secure";
    public static final String FIELDPN_SECURE = "Secure";
    public static final String FIELDDT_SECURE = "checkbox";
    public static final Boolean DEFAULT_SECURE = Boolean.FALSE;
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELDPN_HOMEPAGE = "Home page";
    public static final String DEFAULT_HOMEPAGE = "Main.WebHome";
    public static final String FIELD_ISWIKITEMPLATE = "iswikitemplate";
    public static final String FIELDPN_ISWIKITEMPLATE = "Template";
    public static final String FIELDDT_ISWIKITEMPLATE = "checkbox";
    public static final Boolean DEFAULT_ISWIKITEMPLATE = Boolean.FALSE;
    public static final int FIELDDV_ISWIKITEMPLATE_INT = 0;
    public static final String DEFAULT_PAGE_PARENT = "WikiManager.WebHome";
    private static final String CLASS_SPACE = "XWiki";
    private static final String CLASS_PREFIX = "XWikiServer";
    private static XWikiServerClass instance;

    protected XWikiServerClass() {
        super(CLASS_SPACE, CLASS_PREFIX, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XWikiServerClass getInstance(XWikiContext context) throws XWikiException {
        Class<XWikiServerClass> clazz = XWikiServerClass.class;
        synchronized (XWikiServerClass.class) {
            if (instance == null) {
                instance = new XWikiServerClass();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            instance.check(context);
            return instance;
        }
    }

    public boolean forceValidDocumentName() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            super.check(context);
        }
        finally {
            context.setDatabase(database);
        }
    }

    protected boolean updateBaseClass(BaseClass baseClass) {
        boolean needsUpdate = super.updateBaseClass(baseClass);
        baseClass.setName(this.getClassFullName());
        needsUpdate |= baseClass.addTextField(FIELD_WIKIPRETTYNAME, FIELDPN_WIKIPRETTYNAME, 30);
        needsUpdate |= baseClass.addUsersField(FIELD_OWNER, FIELDPN_OWNER, false);
        needsUpdate |= baseClass.addTextAreaField(FIELD_DESCRIPTION, FIELDPN_DESCRIPTION, 40, 5);
        needsUpdate |= baseClass.addTextField(FIELD_SERVER, FIELDPN_SERVER, 30);
        needsUpdate |= baseClass.addStaticListField(FIELD_VISIBILITY, FIELDPN_VISIBILITY, FIELDL_VISIBILITY);
        needsUpdate |= baseClass.addStaticListField(FIELD_STATE, FIELDPN_STATE, FIELDL_STATE);
        needsUpdate |= baseClass.addStaticListField(FIELD_LANGUAGE, FIELDPN_LANGUAGE, FIELDL_LANGUAGE);
        needsUpdate |= baseClass.addBooleanField(FIELD_SECURE, FIELDPN_SECURE, "checkbox");
        needsUpdate |= this.updateBooleanClassDefaultValue(baseClass, FIELD_SECURE, DEFAULT_SECURE);
        needsUpdate |= baseClass.addTextField(FIELD_HOMEPAGE, FIELDPN_HOMEPAGE, 30);
        needsUpdate |= baseClass.addBooleanField(FIELD_ISWIKITEMPLATE, FIELDPN_ISWIKITEMPLATE, "checkbox");
        return needsUpdate |= this.updateBooleanClassDefaultValue(baseClass, FIELD_ISWIKITEMPLATE, DEFAULT_ISWIKITEMPLATE);
    }

    protected boolean updateClassTemplateDocument(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (!DEFAULT_PAGE_PARENT.equals(doc.getParent())) {
            doc.setParent(DEFAULT_PAGE_PARENT);
            needsUpdate = true;
        }
        needsUpdate |= this.updateDocStringValue(doc, FIELD_HOMEPAGE, DEFAULT_HOMEPAGE);
        needsUpdate |= this.updateDocBooleanValue(doc, FIELD_SECURE, DEFAULT_SECURE);
        return needsUpdate |= this.updateDocBooleanValue(doc, FIELD_ISWIKITEMPLATE, DEFAULT_ISWIKITEMPLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XWikiServer> searchXObjectDocumentsByFields(Object[][] fieldDescriptors, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            List list = super.searchXObjectDocumentsByFields(fieldDescriptors, context);
            return list;
        }
        finally {
            context.setDatabase(database);
        }
    }

    public XWikiServer getWikiAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        try {
            return this.getXObjectDocument(wikiName, objectId, validate, context);
        }
        catch (XObjectDocumentDoesNotExistException e) {
            throw new WikiManagerException(50034, WikiManagerMessageTool.getDefault(context).get("wikimanager.plugin.error.wikialiasdoesnotexists", wikiName), e);
        }
    }

    public XWikiServer getWikiTemplateAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        XWikiServer wiki = this.getWikiAlias(wikiName, objectId, validate, context);
        if (validate && !wiki.isWikiTemplate()) {
            throw new WikiManagerException(50034, WikiManagerMessageTool.getDefault(context).get("wikimanager.plugin.error.wikitemplatealiasdoesnotexists", wikiName));
        }
        return wiki;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiServer getXObjectDocument(String itemName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        String wiki = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            XWikiServer xWikiServer = (XWikiServer)super.getXObjectDocument(itemName, objectId, validate, context);
            return xWikiServer;
        }
        finally {
            context.setDatabase(wiki);
        }
    }

    public XWikiServer newXObjectDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return new XWikiServer(doc, objId, context);
    }
}

