/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.globalsearch;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.core.api.XWikiExceptionApi;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearch;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchException;
import com.xpn.xwiki.plugin.globalsearch.GlobalSearchPlugin;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchQuery;
import com.xpn.xwiki.plugin.globalsearch.tools.GlobalSearchResult;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

public class GlobalSearchPluginApi
extends PluginApi<GlobalSearchPlugin> {
    public static final String CONTEXT_LASTERRORCODE = "lasterrorcode";
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    protected static final Logger LOGGER = LoggerFactory.getLogger(GlobalSearchPluginApi.class);
    private ContextualLocalizationManager localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);
    private GlobalSearch search = new GlobalSearch();

    public GlobalSearchPluginApi(GlobalSearchPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    public void logError(String errorMessage, XWikiException e) {
        LOGGER.error(errorMessage, (Throwable)e);
        this.context.put((Object)CONTEXT_LASTERRORCODE, (Object)e.getCode());
        this.context.put((Object)CONTEXT_LASTEXCEPTION, (Object)new XWikiExceptionApi(e, this.context));
    }

    public GlobalSearchQuery newQuery() {
        return new GlobalSearchQuery();
    }

    public Collection<GlobalSearchResult> search(GlobalSearchQuery query) throws XWikiException {
        Collection<GlobalSearchResult> results;
        try {
            results = this.hasProgrammingRights() ? this.search.search(query, this.context) : Collections.emptyList();
        }
        catch (GlobalSearchException e) {
            this.logError(this.localizationManager.getTranslationPlain("globalsearch.plugin.log.searchdocuments", new Object[0]), (XWikiException)((Object)e));
            results = Collections.emptyList();
        }
        return results;
    }

    public Collection<Document> searchDocuments(GlobalSearchQuery query, boolean distinctbylanguage) throws XWikiException {
        List<Document> documentList;
        try {
            Collection<XWikiDocument> documents = this.search.searchDocuments(query, distinctbylanguage, false, true, this.context);
            documentList = new ArrayList<Document>(documents.size());
            for (XWikiDocument doc : documents) {
                documentList.add(doc.newDocument(this.context));
            }
        }
        catch (GlobalSearchException e) {
            this.logError(this.localizationManager.getTranslationPlain("globalsearch.plugin.log.searchdocuments", new Object[0]), (XWikiException)((Object)e));
            documentList = Collections.emptyList();
        }
        return documentList;
    }

    public Collection<String> searchDocumentsNames(GlobalSearchQuery query, boolean distinctbylanguage, boolean checkRight) throws XWikiException {
        Collection<String> results;
        try {
            results = this.search.searchDocumentsNames(query, distinctbylanguage, false, checkRight, this.context);
        }
        catch (GlobalSearchException e) {
            this.logError(this.localizationManager.getTranslationPlain("globalsearch.plugin.log.searchdocuments", new Object[0]), (XWikiException)((Object)e));
            results = Collections.emptyList();
        }
        return results;
    }
}

