/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.wikimanager;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.core.plugin.XWikiPluginMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.plugin.wikimanager.WikiCopy;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerException;
import com.xpn.xwiki.plugin.wikimanager.WikiManagerMessageTool;
import com.xpn.xwiki.plugin.wikimanager.doc.Wiki;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServer;
import com.xpn.xwiki.plugin.wikimanager.doc.XWikiServerClass;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.WikiCreateFailedEvent;
import org.xwiki.bridge.event.WikiCreatedEvent;
import org.xwiki.bridge.event.WikiCreatingEvent;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.script.service.ScriptService;

public final class WikiManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WikiManager.class);
    private ContextualLocalizationManager localizationManager;
    private WikiCopy wikiCopy = new WikiCopy();

    @Deprecated
    public WikiManager(XWikiPluginMessageTool messageTool) {
        this();
    }

    public WikiManager() {
        this.localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);
    }

    @Deprecated
    public XWikiPluginMessageTool getMessageTool(XWikiContext context) {
        return WikiManagerMessageTool.getDefault(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiDocument getDocument(String wikiName, String fullname, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            XWikiDocument xWikiDocument = context.getWiki().getDocument(fullname, context);
            return xWikiDocument;
        }
        finally {
            context.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XWikiDocument> searchDocuments(String wikiName, String wheresql, XWikiContext context) throws XWikiException {
        String database = context.getDatabase();
        try {
            context.setDatabase(wikiName);
            List list = context.getWiki().getStore().searchDocuments(wheresql, context);
            return list;
        }
        finally {
            context.setDatabase(database);
        }
    }

    public boolean canCreateWiki(XWikiContext context) {
        XWikiRightService rightService = context.getWiki().getRightService();
        return context.getWiki().isVirtualMode() && rightService.hasAdminRights(context) && rightService.hasProgrammingRights(context);
    }

    public boolean canEditWiki(XWikiContext context) {
        XWikiRightService rightService = context.getWiki().getRightService();
        return rightService.hasAdminRights(context) && rightService.hasProgrammingRights(context);
    }

    public boolean canDeleteWiki(XWikiContext context) {
        XWikiRightService rightService = context.getWiki().getRightService();
        return context.getWiki().isVirtualMode() && rightService.hasAdminRights(context) && rightService.hasProgrammingRights(context);
    }

    public Wiki getWikiFromDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        return new Wiki(document, context);
    }

    public Wiki getWikiFromName(String wikiName, XWikiContext context) throws XWikiException {
        return this.getWikiFromDocumentName(context.getMainXWiki() + ":" + XWikiServerClass.getInstance(context).getItemDocumentDefaultFullName(wikiName, context), context);
    }

    public Wiki getWikiFromDocumentName(String documentFullName, XWikiContext context) throws XWikiException {
        return this.getWikiFromDocument(context.getWiki().getDocument(documentFullName, context), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Wiki> getAllWikis(XWikiContext context) throws XWikiException {
        ArrayList<Wiki> wikiList = new ArrayList<Wiki>();
        ArrayList parameterValues = new ArrayList();
        String wheresql = XWikiServerClass.getInstance(context).createWhereClause(null, parameterValues);
        String database = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            List documents = context.getWiki().getStore().searchDocuments(wheresql, parameterValues, context);
            for (XWikiDocument document : documents) {
                wikiList.add(new Wiki(document, context));
            }
            ArrayList<Wiki> arrayList = wikiList;
            return arrayList;
        }
        finally {
            context.setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String>[] getDocsNames(String wiki, XWikiContext context) throws XWikiException {
        Collection[] docsNames = new Collection[2];
        ApplicationManagerPluginApi appmanager = (ApplicationManagerPluginApi)Utils.getComponent(ScriptService.class, (String)"applicationmanager");
        if (appmanager == null) {
            return null;
        }
        String database = context.getDatabase();
        try {
            context.setDatabase(wiki);
            XWikiApplication rootApp = appmanager.getRootApplication();
            if (rootApp != null) {
                docsNames[0] = rootApp.getDocsNameToInclude(true);
                docsNames[1] = rootApp.getDocsNameToLink(true);
            } else {
                List applications = appmanager.getApplicationDocumentList();
                docsNames[0] = XWikiApplication.getDocsNameToInclude((Collection)applications);
                docsNames[1] = XWikiApplication.getDocsNameToLink((Collection)applications);
            }
        }
        finally {
            context.setDatabase(database);
        }
        return docsNames;
    }

    public XWikiServer createNewWikiFromPackage(XWikiServer userWikiSuperDoc, String packageName, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, null, packageName, comment, context);
    }

    public XWikiServer createNewWikiFromTemplate(XWikiServer userWikiSuperDoc, String templateWikiName, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, templateWikiName, null, comment, context);
    }

    public XWikiServer createNewWiki(XWikiServer userWikiSuperDoc, boolean failOnExist, String comment, XWikiContext context) throws XWikiException {
        return this.createNewWiki(userWikiSuperDoc, failOnExist, null, null, comment, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWikiServer createNewWiki(XWikiServer userWikiSuperDoc, boolean failOnExist, String templateWikiName, String packageName, String comment, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.xwikinotvirtual", new Object[0]));
        }
        String newWikiName = userWikiSuperDoc.getWikiName();
        String database = context.getDatabase();
        try {
            context.setDatabase(context.getMainXWiki());
            String wikiForbiddenList = xwiki.Param("xwiki.virtual.reserved_wikis");
            if (Util.contains((String)newWikiName, (String)wikiForbiddenList, (String)", ")) {
                throw new WikiManagerException(50036, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.wikinameforbidden", new Object[]{newWikiName}));
            }
            XWikiServer wikiSuperDocToSave = this.getWikiDescriptorToSave(userWikiSuperDoc, failOnExist, context);
            if (this.getDocument(xwiki.getDatabase(), wikiSuperDocToSave.getOwner(), context).isNew()) {
                LOGGER.warn(this.localizationManager.getTranslationPlain("wikimanager.plugin.error.userdoesnotexists", new Object[]{wikiSuperDocToSave.getOwner()}));
                wikiSuperDocToSave.setOwner("superadmin");
            }
            ((ObservationManager)Utils.getComponent(ObservationManager.class)).notify((Event)new WikiCreatingEvent(newWikiName), (Object)newWikiName, (Object)context);
            boolean sucess = false;
            try {
                this.createWikiDatabase(newWikiName, context, templateWikiName == null);
                XWikiDocument wikiSuperXDocToSave = wikiSuperDocToSave.getDocument();
                context.getWiki().saveDocument(wikiSuperXDocToSave, comment, context);
                sucess = true;
                if (templateWikiName != null) {
                    this.wikiCopy.copyWiki(templateWikiName, newWikiName, comment, context);
                }
                if (packageName != null) {
                    this.wikiCopy.importPackage(packageName, newWikiName, context);
                }
                context.setDatabase(context.getMainXWiki());
            }
            finally {
                if (sucess) {
                    ((ObservationManager)Utils.getComponent(ObservationManager.class)).notify((Event)new WikiCreatedEvent(newWikiName), (Object)newWikiName, (Object)context);
                } else {
                    ((ObservationManager)Utils.getComponent(ObservationManager.class)).notify((Event)new WikiCreateFailedEvent(newWikiName), (Object)newWikiName, (Object)context);
                }
            }
            XWikiServer xWikiServer = wikiSuperDocToSave;
            return xWikiServer;
        }
        finally {
            context.setDatabase(database);
        }
    }

    private XWikiServer getWikiDescriptorToSave(XWikiServer userWikiSuperDoc, boolean failOnExist, XWikiContext context) throws XWikiException {
        XWikiServer wikiSuperDocToSave;
        XWiki xwiki = context.getWiki();
        XWikiServerClass wikiClass = XWikiServerClass.getInstance(context);
        if (!userWikiSuperDoc.isFromCache()) {
            XWikiDocument docToSave = this.getDocument(context.getMainXWiki(), userWikiSuperDoc.getFullName(), context);
            if (!docToSave.isNew() && wikiClass.isInstance(docToSave)) {
                if (failOnExist) {
                    throw new WikiManagerException(50033, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.descriptoralreadyexists", new Object[]{userWikiSuperDoc.getFullName()}));
                }
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.createwiki.descriptoralreadyexists", new Object[]{userWikiSuperDoc.toString()}));
                }
            }
            if (!(wikiSuperDocToSave = wikiClass.newXObjectDocument(docToSave, 0, context)).getServer().equals(userWikiSuperDoc.getServer())) {
                xwiki.getVirtualWikiCache().remove(userWikiSuperDoc.getServer());
            }
            wikiSuperDocToSave.mergeObject(userWikiSuperDoc);
        } else {
            wikiSuperDocToSave = userWikiSuperDoc;
        }
        return wikiSuperDocToSave;
    }

    private void createWikiDatabase(String targetWiki, XWikiContext context, boolean initClasses) throws WikiManagerException {
        XWiki xwiki = context.getWiki();
        if (!xwiki.isVirtualMode()) {
            throw new WikiManagerException(50037, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.xwikinotvirtual", new Object[0]));
        }
        try {
            xwiki.getStore().createWiki(targetWiki, context);
        }
        catch (Exception e) {
            LOGGER.warn(this.localizationManager.getTranslationPlain("wikimanager.plugin.log.createwiki.databasecreationexception", new Object[]{targetWiki}), (Throwable)e);
        }
        try {
            xwiki.updateDatabase(targetWiki, true, initClasses, context);
        }
        catch (Exception e) {
            throw new WikiManagerException(50035, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.updatedatabase", new Object[]{targetWiki}), e);
        }
    }

    public void deleteWiki(String wikiNameToDelete, boolean deleteDatabase, XWikiContext context) throws XWikiException {
        Wiki wiki = this.getWikiFromName(wikiNameToDelete, context);
        if (!XWikiServerClass.getInstance(context).isInstance(wiki)) {
            throw new WikiManagerException(50034, this.localizationManager.getTranslationPlain("wikimanager.plugin.error.wikidoesnotexists", new Object[]{wikiNameToDelete}));
        }
        wiki.delete(deleteDatabase);
    }

    public void deleteWikiAlias(String wikiNameToDelete, int objectId, XWikiContext context) throws XWikiException {
        Wiki wiki = this.getWikiFromName(wikiNameToDelete, context);
        XWikiServer alias = wiki.getWikiAlias(objectId);
        if (wiki.countWikiAliases() == 1) {
            wiki.delete(true);
        } else {
            alias.delete();
        }
    }

    public XWikiServer getWikiAlias(String wikiName, int objectId, boolean validate, XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).getWikiAlias(wikiName, objectId, validate, context);
    }

    public List<XWikiServer> getWikiAliasList(XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).searchXObjectDocuments(context);
    }

    public boolean isWikiAliasExist(String wikiName, int objectId, XWikiContext context) {
        try {
            return this.getWikiAlias(wikiName, objectId, true, context) != null;
        }
        catch (XWikiException e) {
            return false;
        }
    }

    public XWikiServer getWikiTemplateAlias(String wikiName, int objectId, XWikiContext context, boolean validate) throws XWikiException {
        return XWikiServerClass.getInstance(context).getWikiTemplateAlias(wikiName, objectId, validate, context);
    }

    public List<XWikiServer> getWikiTemplateAliasList(XWikiContext context) throws XWikiException {
        return XWikiServerClass.getInstance(context).searchXObjectDocumentsByField("iswikitemplate", 1, "IntegerProperty", context);
    }

    public void createWikiTemplate(XWikiServer wikiXObjectDocument, String packageName, String comment, XWikiContext context) throws XWikiException {
        wikiXObjectDocument.setIsWikiTemplate(true);
        this.createNewWikiFromPackage(wikiXObjectDocument, packageName, false, comment, context);
    }
}

