/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.template.script;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;
import org.xwiki.wiki.provisioning.WikiProvisioningJob;
import org.xwiki.wiki.template.WikiTemplateManager;
import org.xwiki.wiki.template.WikiTemplateManagerException;

@Component
@Named(value="wiki.template")
@Singleton
public class WikiTemplateManagerScript
implements ScriptService {
    @Deprecated
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    private static final String WIKITEMPLATEERROR_KEY = "scriptservice.wiki.template.error";
    @Inject
    private WikiTemplateManager wikiTemplateManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(WIKITEMPLATEERROR_KEY);
    }

    private void setLastError(Exception e) {
        this.execution.getContext().setProperty(WIKITEMPLATEERROR_KEY, (Object)e);
    }

    public Collection<WikiDescriptor> getTemplates() {
        try {
            return this.wikiTemplateManager.getTemplates();
        }
        catch (WikiTemplateManagerException e) {
            this.error("Error while getting all the wiki templates.", (Exception)((Object)e));
            return new ArrayList<WikiDescriptor>();
        }
    }

    public boolean setTemplate(String wikiId, boolean value) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            this.authorizationManager.checkAccess(Right.PROGRAM, context.getDoc().getAuthorReference(), (EntityReference)context.getDoc().getDocumentReference());
            WikiDescriptor descriptor = this.wikiDescriptorManager.getById(wikiId);
            String owner = descriptor.getOwnerId();
            WikiReference wikiReference = new WikiReference(descriptor.getId());
            String currentUser = (String)this.entityReferenceSerializer.serialize((EntityReference)context.getUserReference(), new Object[0]);
            if (!currentUser.equals(owner)) {
                this.authorizationManager.checkAccess(Right.ADMIN, context.getUserReference(), (EntityReference)wikiReference);
            }
            this.wikiTemplateManager.setTemplate(wikiId, value);
            return true;
        }
        catch (WikiTemplateManagerException e) {
            this.error(String.format("Failed to set the template value [%s] for the wiki [%s].", value, wikiId), (Exception)((Object)e));
            return false;
        }
        catch (AccessDeniedException e) {
            this.error(String.format("Access denied for [%s] to change the template value of the wiki [%s]. The user has not the right to perform this operation or the script has not the programming right.", context.getUserReference(), wikiId), (Exception)((Object)e));
            return false;
        }
        catch (WikiManagerException e) {
            this.error(String.format("Failed to get the descriptor of the wiki [%s].", wikiId), (Exception)((Object)e));
            return false;
        }
    }

    public Boolean isTemplate(String wikiId) {
        try {
            return this.wikiTemplateManager.isTemplate(wikiId);
        }
        catch (WikiTemplateManagerException e) {
            this.error(String.format("Failed to get if the wiki [%s] is a template or not.", wikiId), (Exception)((Object)e));
            return null;
        }
    }

    @Deprecated
    public boolean createWikiFromTemplate(String newWikiId, String newWikiAlias, String templateId, String ownerId, boolean failOnExist) {
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            this.authorizationManager.checkAccess(Right.PROGRAM, context.getDoc().getAuthorReference(), (EntityReference)context.getDoc().getDocumentReference());
            this.authorizationManager.checkAccess(Right.CREATE_WIKI, context.getUserReference(), (EntityReference)new WikiReference(context.getMainXWiki()));
            this.wikiTemplateManager.createWikiFromTemplate(newWikiId, newWikiAlias, templateId, ownerId, failOnExist);
            return true;
        }
        catch (WikiTemplateManagerException e) {
            this.error("Failed to create the wiki from the template.", (Exception)((Object)e));
        }
        catch (AccessDeniedException e) {
            this.error("Error, you or this script does not have the right to create a wiki from a template.", (Exception)((Object)e));
        }
        return false;
    }

    private void error(String errorMessage, Exception e) {
        this.logger.error(errorMessage, (Throwable)e);
        this.setLastError(e);
        this.execution.getContext().setProperty(CONTEXT_LASTEXCEPTION, (Object)e);
    }

    @Deprecated
    public Exception getLastException() {
        return (Exception)this.execution.getContext().getProperty(CONTEXT_LASTEXCEPTION);
    }

    @Deprecated
    public JobStatus getWikiProvisioningJobStatus(List<String> jobId) {
        try {
            WikiProvisioningJob wikiProvisioningJob = this.wikiTemplateManager.getWikiProvisioningJob(jobId);
            if (wikiProvisioningJob == null) {
                return null;
            }
            return wikiProvisioningJob.getStatus();
        }
        catch (WikiTemplateManagerException e) {
            this.error("Failed to get tge wiki provisioning job.", (Exception)((Object)e));
            return null;
        }
    }
}

