/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserConfiguration;
import org.xwiki.wiki.user.WikiUserManagerException;
import org.xwiki.wiki.user.internal.WikiUserConfigurationHelper;

@Component
@Named(value="R530010WikiUserFromXEMMigration")
@Singleton
public class WikiUserFromXEMMigration
extends AbstractHibernateDataMigration {
    private static final String WORKSPACE_CLASS_SPACE = "WorkspaceManager";
    private static final String WORKSPACE_CLASS_PAGE = "WorkspaceClass";
    @Inject
    private WikiUserConfigurationHelper wikiUserConfigurationHelper;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "http://jira.xwiki.org/browse/XWIKI-9516";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(53010);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return !this.wikiDescriptorManager.getCurrentWikiId().equals(this.wikiDescriptorManager.getMainWikiId());
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        DocumentReference oldClassDocument;
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference oldWikiDescriptorReference = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), "XWiki", String.format("XWikiServer%s", StringUtils.capitalize((String)currentWikiId)));
        XWikiDocument oldWikiDescriptor = xwiki.getDocument(oldWikiDescriptorReference, context);
        BaseObject oldObject = oldWikiDescriptor.getXObject(oldClassDocument = new DocumentReference(this.wikiDescriptorManager.getMainWikiId(), WORKSPACE_CLASS_SPACE, WORKSPACE_CLASS_PAGE));
        if (oldObject != null || this.isWorkspaceTemplate(currentWikiId)) {
            this.upgradeWorkspace(oldObject, currentWikiId, oldWikiDescriptor);
        } else {
            this.upgradeRegularSubwiki(currentWikiId);
        }
    }

    private boolean isWorkspaceTemplate(String wikiId) {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        return wikiId.equals("workspacetemplate") && xwiki.exists(new DocumentReference(wikiId, "XWiki", "ManageWorkspace"), context);
    }

    private void saveConfiguration(WikiUserConfiguration configuration, String wikiId) throws DataMigrationException, XWikiException {
        try {
            this.wikiUserConfigurationHelper.saveConfiguration(configuration, wikiId);
        }
        catch (WikiUserManagerException e) {
            throw new DataMigrationException(String.format("Failed to save the new wiki user configuration page for wiki [%s].", wikiId), (Throwable)e);
        }
    }

    private void upgradeRegularSubwiki(String wikiId) throws DataMigrationException, XWikiException {
        WikiUserConfiguration configuration = new WikiUserConfiguration();
        configuration.setUserScope(UserScope.LOCAL_AND_GLOBAL);
        configuration.setMembershipType(MembershipType.INVITE);
        this.saveConfiguration(configuration, wikiId);
    }

    private void upgradeWorkspace(BaseObject oldObject, String wikiId, XWikiDocument oldWikiDescriptor) throws DataMigrationException, XWikiException {
        this.upgradeWorkspaceConfiguration(oldObject, wikiId, oldWikiDescriptor);
        try {
            this.upgradeWorkspaceCandidacies(wikiId);
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Unable to upgrade candidacies from the old Workspace Application to the new Wiki Application.");
        }
        if (oldObject != null) {
            this.deleteOldWorkspaceObject(oldObject, oldWikiDescriptor);
        }
    }

    private void upgradeWorkspaceConfiguration(BaseObject oldObject, String wikiId, XWikiDocument oldWikiDescriptor) throws DataMigrationException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        WikiUserConfiguration configuration = new WikiUserConfiguration();
        configuration.setUserScope(UserScope.GLOBAL_ONLY);
        if (oldObject != null) {
            MembershipType membershipType;
            String membershipTypeValue = oldObject.getStringValue("membershipType");
            try {
                membershipType = MembershipType.valueOf((String)membershipTypeValue.toUpperCase());
            }
            catch (Exception e) {
                membershipType = MembershipType.INVITE;
            }
            configuration.setMembershipType(membershipType);
        } else {
            configuration.setMembershipType(MembershipType.INVITE);
        }
        this.saveConfiguration(configuration, wikiId);
    }

    private void deleteOldWorkspaceObject(BaseObject oldObject, XWikiDocument oldWikiDescriptor) throws DataMigrationException {
        XWikiContext context = this.getXWikiContext();
        XWiki xwiki = context.getWiki();
        oldWikiDescriptor.removeXObject(oldObject);
        try {
            xwiki.saveDocument(oldWikiDescriptor, "[UPGRADE] Remove the old WorkspaceManager.WorkspaceClass object.", context);
        }
        catch (XWikiException e) {
            throw new DataMigrationException(String.format("Failed to save the document [%s] to remove the WorkspaceManager.WorkspaceClass object.", oldWikiDescriptor.getDocumentReference().toString()), (Throwable)e);
        }
    }

    private void upgradeWorkspaceCandidacies(String wikiId) throws XWikiException {
        DocumentReference oldCandidateClassReference;
        DocumentReference candidaciesDocumentReference;
        XWikiContext xcontext = this.getXWikiContext();
        XWiki xwiki = xcontext.getWiki();
        XWikiDocument candidaciesDocument = xwiki.getDocument(candidaciesDocumentReference = new DocumentReference(wikiId, "XWiki", "XWikiAllGroup"), xcontext);
        List candidacyObjects = candidaciesDocument.getXObjects(oldCandidateClassReference = new DocumentReference(wikiId, "XWiki", "WorkspaceCandidateMemberClass"));
        if (candidacyObjects != null) {
            DocumentReference newCandidateClassReference = new DocumentReference(wikiId, "WikiManager", "WikiCandidateMemberClass");
            for (BaseObject oldObject : candidacyObjects) {
                if (oldObject == null) continue;
                BaseObject newObject = candidaciesDocument.newXObject((EntityReference)newCandidateClassReference, xcontext);
                newObject.setStringValue("type", oldObject.getStringValue("type"));
                newObject.setStringValue("status", oldObject.getStringValue("status"));
                newObject.setStringValue("userName", oldObject.getStringValue("userName"));
                newObject.setLargeStringValue("userComment", oldObject.getLargeStringValue("userComment"));
                newObject.setStringValue("reviewer", oldObject.getStringValue("reviewer"));
                newObject.setLargeStringValue("reviewerComment", oldObject.getLargeStringValue("reviewerComment"));
                newObject.setLargeStringValue("reviewerPrivateComment", oldObject.getLargeStringValue("reviewerPrivateComment"));
                newObject.setDateValue("date", oldObject.getDateValue("date"));
                newObject.setDateValue("resolutionDate", oldObject.getDateValue("resolutionDate"));
                candidaciesDocument.removeXObject(oldObject);
            }
            xwiki.saveDocument(candidaciesDocument, "Upgrade candidacies from the old Workspace Application to the new Wiki Application.", xcontext);
        }
    }
}

