/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wiki.user.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserConfiguration;
import org.xwiki.wiki.user.WikiUserManagerException;
import org.xwiki.wiki.user.internal.WikiUserClassDocumentInitializer;
import org.xwiki.wiki.user.internal.WikiUserConfigurationHelper;

@Component
@Singleton
public class DefaultWikiUserConfigurationHelper
implements WikiUserConfigurationHelper {
    private static final String CONFIGURATION_PAGE_NAME = "WikiUserConfiguration";
    private static final String CONFIGURATION_SPACE_NAME = "WikiManager";
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    private XWikiDocument getDocument(String wikiId) throws WikiUserManagerException {
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            XWiki xwiki = context.getWiki();
            DocumentReference reference = new DocumentReference(wikiId, CONFIGURATION_SPACE_NAME, CONFIGURATION_PAGE_NAME);
            return xwiki.getDocument(reference, context);
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException(String.format("Fail to get the configuration document for wiki [%s].", wikiId));
        }
    }

    @Override
    public WikiUserConfiguration getConfiguration(String wikiId) throws WikiUserManagerException {
        WikiUserConfiguration configuration = new WikiUserConfiguration();
        XWikiDocument document = this.getDocument(wikiId);
        BaseObject object = document.getXObject(WikiUserClassDocumentInitializer.CONFIGURATION_CLASS);
        if (object != null) {
            MembershipType membershipType;
            UserScope userScope;
            String scopeValue = object.getStringValue("userScope");
            try {
                userScope = UserScope.valueOf((String)scopeValue.toUpperCase());
            }
            catch (Exception e) {
                userScope = UserScope.LOCAL_AND_GLOBAL;
            }
            configuration.setUserScope(userScope);
            String membershipTypeValue = object.getStringValue("membershipType");
            try {
                membershipType = MembershipType.valueOf((String)membershipTypeValue.toUpperCase());
            }
            catch (Exception e) {
                membershipType = MembershipType.INVITE;
            }
            configuration.setMembershipType(membershipType);
        }
        return configuration;
    }

    @Override
    public void saveConfiguration(WikiUserConfiguration configuration, String wikiId) throws WikiUserManagerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = this.getDocument(wikiId);
        BaseObject object = document.getXObject(WikiUserClassDocumentInitializer.CONFIGURATION_CLASS, true, context);
        object.setStringValue("userScope", configuration.getUserScope().name().toLowerCase());
        if (configuration.getMembershipType() != null) {
            object.setStringValue("membershipType", configuration.getMembershipType().name().toLowerCase());
        }
        try {
            XWiki xwiki = context.getWiki();
            document.setHidden(Boolean.valueOf(true));
            if (document.getCreatorReference() == null) {
                document.setCreatorReference(context.getUserReference());
            }
            if (document.getAuthorReference() == null) {
                document.setAuthorReference(context.getUserReference());
            }
            xwiki.saveDocument(document, "Changed configuration.", context);
        }
        catch (XWikiException e) {
            throw new WikiUserManagerException(String.format("Fail to save the confguration document for wiki [%s].", wikiId), (Throwable)e);
        }
    }
}

