/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.output;

import java.util.Collection;
import java.util.Map;

import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;
import org.xwiki.wikistream.WikiStream;
import org.xwiki.wikistream.WikiStreamException;

/**
 * @version $Id: f287acbde42aeb4c53b0a7be3be30173736ff200 $
 * @since 5.2M2
 */
@Role
@Unstable
public interface OutputWikiStreamFactory extends WikiStream
{
    OutputWikiStream creaOutputWikiStream(Map<String, Object> properties) throws WikiStreamException;

    /**
     * @return the filters supported by this stream factory
     * @throws WikiStreamException when failing to get filters interfacesO
     * @since 5.2
     */
    Collection<Class< ? >> getFilterInterfaces() throws WikiStreamException;
}
