/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.internal.input;

import java.io.Reader;
import java.io.StringReader;

/**
 * @version $Id: 34e5b1ce7799358bb083d23e80cda97f465b7599 $
 * @since 5.2M2
 */
public class StringInputSource extends AbstractReaderInputSource
{
    private String source;

    public StringInputSource(String source)
    {
        this.source = source;
    }

    @Override
    protected Reader openReader()
    {
        return new StringReader(source);
    }

    @Override
    public String toString()
    {
        return this.source;
    }
}
