/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.internal.job;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.internal.AbstractJob;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.wikistream.input.InputWikiStream;
import org.xwiki.wikistream.input.InputWikiStreamFactory;
import org.xwiki.wikistream.job.WikiStreamConverterJobRequest;
import org.xwiki.wikistream.output.OutputWikiStream;
import org.xwiki.wikistream.output.OutputWikiStreamFactory;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="wikistream.converter")
public class WikiStreamConverterJob
extends AbstractJob<WikiStreamConverterJobRequest, DefaultJobStatus<WikiStreamConverterJobRequest>> {
    public static final String JOBTYPE = "wikistream.converter";
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public String getType() {
        return JOBTYPE;
    }

    protected void runInternal() throws Exception {
        InputWikiStreamFactory inputFactory = (InputWikiStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(InputWikiStreamFactory.class, ((WikiStreamConverterJobRequest)this.getRequest()).getInputType().serialize());
        InputWikiStream inputWikiStream = inputFactory.createInputWikiStream(((WikiStreamConverterJobRequest)this.getRequest()).getInputProperties());
        OutputWikiStreamFactory outputFactory = (OutputWikiStreamFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(OutputWikiStreamFactory.class, ((WikiStreamConverterJobRequest)this.getRequest()).getOutputType().serialize());
        OutputWikiStream outputWikiStream = outputFactory.createOutputWikiStream(((WikiStreamConverterJobRequest)this.getRequest()).getOutputProperties());
        inputWikiStream.read(outputWikiStream.getFilter());
        inputWikiStream.close();
        outputWikiStream.close();
    }
}

