/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.instance.internal.output;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.descriptor.CompositeWikiStreamDescriptor;
import org.xwiki.wikistream.descriptor.WikiStreamDescriptor;
import org.xwiki.wikistream.instance.output.InstanceOutputProperties;
import org.xwiki.wikistream.instance.output.OutputInstanceWikiStreamFactory;
import org.xwiki.wikistream.internal.output.AbstractBeanOutputWikiStreamFactory;
import org.xwiki.wikistream.type.WikiStreamType;

@Component
@Named(value="xwiki+instance")
@Singleton
public class InstanceOutputWikiStreamFactory
extends AbstractBeanOutputWikiStreamFactory<InstanceOutputProperties, Object> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public InstanceOutputWikiStreamFactory() {
        super(WikiStreamType.XWIKI_INSTANCE);
        this.setName("XWiki instance output stream");
        this.setDescription("Setup XWiki instance from wiki events.");
    }

    public void initialize() throws InitializationException {
        List factories;
        super.initialize();
        try {
            factories = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(OutputInstanceWikiStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to get registered instance of OutputInstanceWikiStreamFactory components", (Throwable)e);
        }
        WikiStreamDescriptor[] descriptors = new WikiStreamDescriptor[factories.size() + 1];
        descriptors[0] = this.descriptor;
        for (int i = 0; i < factories.size(); ++i) {
            descriptors[i + 1] = ((OutputInstanceWikiStreamFactory)factories.get(i)).getDescriptor();
        }
        this.setDescriptor((WikiStreamDescriptor)new CompositeWikiStreamDescriptor(this.descriptor.getName(), this.descriptor.getDescription(), descriptors));
    }

    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        List factories;
        try {
            factories = ((ComponentManager)this.componentManagerProvider.get()).getInstanceList(OutputInstanceWikiStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to get regsitered instance of OutputInstanceWikiStreamFactory components", (Throwable)e);
        }
        HashSet filters = new HashSet();
        for (OutputInstanceWikiStreamFactory factory : factories) {
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }
}

