/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.wikixml.internal.output;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.xml.serializer.XMLSerializerFactory;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputWikiStreamFactory;
import org.xwiki.wikistream.type.WikiStreamType;
import org.xwiki.wikistream.wikixml.internal.input.WikiXMLInputWikiStreamFactory;
import org.xwiki.wikistream.wikixml.output.WikiXMLOutputProperties;
import org.xwiki.wikistream.xml.internal.output.AbstractXMLBeanOutputWikiStreamFactory;

@Component
@Named(value="wiki+xml")
@Singleton
public class WikiXMLOutputWikiStreamFactory
extends AbstractXMLBeanOutputWikiStreamFactory<WikiXMLOutputProperties, Object> {
    @Inject
    private XMLSerializerFactory serializerFactory;
    @Inject
    private Provider<ComponentManager> contextComponentManager;

    public WikiXMLOutputWikiStreamFactory() {
        super(WikiStreamType.WIKI_XML);
        this.setName("Generic XML output stream");
        this.setDescription("Write generic XML from wiki events.");
    }

    public Collection<Class<?>> getFilterInterfaces() throws WikiStreamException {
        List factories;
        try {
            factories = ((ComponentManager)this.contextComponentManager.get()).getInstanceList(InputWikiStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to lookup InputWikiStreamFactory components instances", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.add(UnknownFilter.class);
        for (InputWikiStreamFactory factory : factories) {
            if (factory.getClass() == WikiXMLInputWikiStreamFactory.class) continue;
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }

    protected Object createListener(Result result, WikiXMLOutputProperties properties) throws XMLStreamException, FactoryConfigurationError, WikiStreamException {
        return this.serializerFactory.createSerializer(this.getFilterInterfaces().toArray(ArrayUtils.EMPTY_CLASS_ARRAY), result, null);
    }
}

