/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.XARObjectModel;
import org.xwiki.wikistream.xar.internal.XARWikiStreamUtils;
import org.xwiki.wikistream.xar.internal.input.AbstractReader;
import org.xwiki.wikistream.xar.internal.input.ClassPropertyReader;
import org.xwiki.wikistream.xar.internal.input.ClassReader;
import org.xwiki.wikistream.xar.internal.input.XARXMLReader;
import org.xwiki.xar.internal.XarObjectPropertySerializerManager;

@Component
@Singleton
public class WikiObjectReader
extends AbstractReader
implements XARXMLReader<WikiObject> {
    @Inject
    private XarObjectPropertySerializerManager propertySerializerManager;
    @Inject
    private XARXMLReader<ClassReader.WikiClass> classReader;

    @Override
    public WikiObject read(XMLStreamReader xmlReader) throws XMLStreamException, WikiStreamException {
        WikiObject wikiObject = new WikiObject();
        xmlReader.nextTag();
        while (xmlReader.isStartElement()) {
            String elementName = xmlReader.getLocalName();
            if (elementName.equals("class")) {
                wikiObject.wikiClass = this.classReader.read(xmlReader);
            } else if (elementName.equals("property")) {
                wikiObject.properties.add(this.readObjectProperty(xmlReader, wikiObject.wikiClass));
            } else {
                Object wsValue;
                String value = xmlReader.getElementText();
                XARWikiStreamUtils.EventParameter parameter = XARObjectModel.OBJECT_PARAMETERS.get(elementName);
                if (parameter != null && (wsValue = this.convert(parameter.type, value)) != null) {
                    wikiObject.parameters.put((Object)parameter.name, wsValue);
                }
            }
            xmlReader.nextTag();
        }
        return wikiObject;
    }

    private WikiObjectProperty readObjectProperty(XMLStreamReader xmlReader, ClassReader.WikiClass wikiClass) throws XMLStreamException, WikiStreamException {
        ClassPropertyReader.WikiClassProperty classProperty;
        xmlReader.nextTag();
        WikiObjectProperty property = new WikiObjectProperty();
        property.name = xmlReader.getLocalName();
        String type = wikiClass != null ? ((classProperty = wikiClass.properties.get(property.name)) != null ? classProperty.type : null) : null;
        try {
            property.value = this.propertySerializerManager.getPropertySerializer(type).read(xmlReader);
        }
        catch (ComponentLookupException e) {
            throw new WikiStreamException("Failed to get a property parser", (Throwable)e);
        }
        xmlReader.nextTag();
        return property;
    }

    public class WikiObjectProperty {
        public String name;
        public Object value;
        public FilterEventParameters parameters = new FilterEventParameters();

        public void send(XARFilter proxyFilter) throws WikiStreamException {
            proxyFilter.onWikiObjectProperty(this.name, this.value, this.parameters);
        }
    }

    public static class WikiObject {
        public ClassReader.WikiClass wikiClass;
        public FilterEventParameters parameters = new FilterEventParameters();
        private List<WikiObjectProperty> properties = new ArrayList<WikiObjectProperty>();

        public void send(XARFilter proxyFilter) throws WikiStreamException {
            String name = null;
            if (this.parameters.containsKey((Object)"class_reference")) {
                StringBuilder nameBuilder = new StringBuilder(this.parameters.get((Object)"class_reference").toString());
                if (this.parameters.containsKey((Object)"number")) {
                    nameBuilder.append('[');
                    nameBuilder.append(this.parameters.get((Object)"number"));
                    nameBuilder.append(']');
                }
                name = nameBuilder.toString();
            }
            proxyFilter.beginWikiObject(name, this.parameters);
            if (this.wikiClass != null) {
                this.wikiClass.send(proxyFilter);
            }
            for (WikiObjectProperty property : this.properties) {
                property.send(proxyFilter);
            }
            proxyFilter.endWikiObject(name, this.parameters);
        }
    }
}

