/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.output;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.internal.output.AbstractBeanOutputWikiStream;
import org.xwiki.wikistream.output.WriterOutputTarget;
import org.xwiki.wikistream.xar.internal.XARFilter;
import org.xwiki.wikistream.xar.internal.output.XARWikiWriter;
import org.xwiki.wikistream.xar.output.XAROutputProperties;
import org.xwiki.wikistream.xml.internal.output.WikiStreamXMLStreamWriter;
import org.xwiki.wikistream.xml.output.ResultOutputTarget;
import org.xwiki.wikistream.xml.output.XMLOutputProperties;
import org.xwiki.xar.internal.XarObjectPropertySerializerManager;

@Component
@Named(value="xwiki+xar/1.1")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XAROutputWikiStream
extends AbstractBeanOutputWikiStream<XAROutputProperties>
implements XARFilter {
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private EntityReferenceSerializer<String> defaultSerializer;
    @Inject
    private XarObjectPropertySerializerManager propertySerializerManager;
    private XARWikiWriter wikiWriter;
    private String currentSpace;
    private String currentDocument;
    private FilterEventParameters currentDocumentParameters;
    private LocalDocumentReference currentDocumentReference;
    private String currentDocumentVersion;
    private String currentObjectClass;
    private WikiStreamXMLStreamWriter writer;
    private Map<String, String> currentObjectProperties;
    private static final int ATTACHMENT_BUFFER_CHUNK_SIZE = 4095;

    public void close() throws IOException {
        if (this.wikiWriter != null) {
            this.wikiWriter.close();
        }
        ((XAROutputProperties)((Object)this.properties)).getTarget().close();
    }

    public String toString(Object obj) {
        return ObjectUtils.toString((Object)obj, null);
    }

    public String toString(Date date) {
        return date != null ? String.valueOf(date.getTime()) : null;
    }

    public String toString(Syntax syntax) {
        return syntax != null ? syntax.toIdString() : null;
    }

    public String toString(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public String toString(EntityReference reference) {
        return (String)this.defaultSerializer.serialize(reference, new Object[0]);
    }

    public void beginFarm(FilterEventParameters parameters) throws WikiStreamException {
    }

    public void endFarm(FilterEventParameters parameters) throws WikiStreamException {
    }

    public void beginWiki(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.wikiWriter = new XARWikiWriter(((XAROutputProperties)((Object)this.properties)).getPackageName() != null ? ((XAROutputProperties)((Object)this.properties)).getPackageName() : name, (XAROutputProperties)((Object)this.properties));
    }

    public void endWiki(String name, FilterEventParameters parameters) throws WikiStreamException {
        try {
            this.wikiWriter.close();
        }
        catch (IOException e) {
            throw new WikiStreamException("Failed to close XAR writer", (Throwable)e);
        }
        this.wikiWriter = null;
    }

    public void beginWikiSpace(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentSpace = name;
    }

    public void endWikiSpace(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentSpace = null;
    }

    public void beginWikiDocument(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentDocument = name;
        this.currentDocumentParameters = parameters;
        this.currentDocumentReference = new LocalDocumentReference(this.currentSpace, this.currentDocument);
    }

    public void endWikiDocument(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.currentDocument = null;
        this.currentDocumentReference = null;
        this.currentDocumentParameters = null;
    }

    private boolean isTargetTextualContent() {
        return ((XAROutputProperties)((Object)this.properties)).getTarget() instanceof WriterOutputTarget || ((XAROutputProperties)((Object)this.properties)).getTarget() instanceof ResultOutputTarget;
    }

    public void beginWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws WikiStreamException {
        if (this.writer == null) {
            if (this.wikiWriter == null && (((XAROutputProperties)((Object)this.properties)).isForceDocument() || this.isTargetTextualContent())) {
                this.writer = new WikiStreamXMLStreamWriter((XMLOutputProperties)this.properties, true);
            } else {
                if (this.wikiWriter == null) {
                    this.wikiWriter = new XARWikiWriter(((XAROutputProperties)((Object)this.properties)).getPackageName() != null ? ((XAROutputProperties)((Object)this.properties)).getPackageName() : "package", (XAROutputProperties)((Object)this.properties));
                }
                this.writer = new WikiStreamXMLStreamWriter(this.wikiWriter.newEntry(new LocalDocumentReference((EntityReference)this.currentDocumentReference, locale)), ((XAROutputProperties)((Object)this.properties)).getEncoding(), ((XAROutputProperties)((Object)this.properties)).isFormat(), true);
            }
        }
        this.writer.writeStartDocument(((XAROutputProperties)((Object)this.properties)).getEncoding(), "1.0");
        this.writer.writeStartElement("xwikidoc");
        this.writer.writeAttribute("version", "1.1");
        this.writer.writeElement("web", this.currentSpace);
        this.writer.writeElement("name", this.currentDocument);
        this.writer.writeElement("language", this.toString(locale));
        this.writer.writeElement("defaultLanguage", this.toString(this.currentDocumentParameters.get((Object)"locale")));
        this.writer.writeElement("translation", locale != null && !Locale.ROOT.equals(locale) ? "1" : "0");
        if (parameters.containsKey((Object)"creation_author")) {
            this.writer.writeElement("creator", (String)parameters.get((Object)"creation_author"));
        }
        if (parameters.containsKey((Object)"creation_date")) {
            this.writer.writeElement("creationDate", this.toString((Date)parameters.get((Object)"creation_date")));
        }
        if (((XAROutputProperties)((Object)this.properties)).isPreserveVersion() && parameters.containsKey((Object)"xwiki_jrcsrevisions")) {
            this.writer.writeElement("versions", (String)parameters.get((Object)"xwiki_jrcsrevisions"));
        }
    }

    public void endWikiDocumentLocale(Locale locale, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
        if (this.wikiWriter != null) {
            this.wikiWriter.closeEntry();
        }
        this.writer = null;
    }

    public void beginWikiDocumentRevision(String version, FilterEventParameters parameters) throws WikiStreamException {
        this.currentDocumentVersion = version;
        if (parameters.containsKey((Object)"parent_reference")) {
            this.writer.writeElement("parent", this.toString((EntityReference)parameters.get((Object)"parent_reference")));
        }
        if (parameters.containsKey((Object)"revision_author")) {
            this.writer.writeElement("author", (String)parameters.get((Object)"revision_author"));
        }
        if (parameters.containsKey((Object)"customclass")) {
            this.writer.writeElement("customClass", (String)parameters.get((Object)"customclass"));
        }
        if (parameters.containsKey((Object)"content_author")) {
            this.writer.writeElement("contentAuthor", (String)parameters.get((Object)"content_author"));
        }
        if (parameters.containsKey((Object)"revision_date")) {
            this.writer.writeElement("date", this.toString((Date)parameters.get((Object)"revision_date")));
        }
        if (parameters.containsKey((Object)"content_date")) {
            this.writer.writeElement("contentUpdateDate", this.toString((Date)parameters.get((Object)"content_date")));
        }
        this.writer.writeElement("version", this.currentDocumentVersion);
        if (parameters.containsKey((Object)"title")) {
            this.writer.writeElement("title", (String)parameters.get((Object)"title"));
        }
        if (parameters.containsKey((Object)"defaulttemplate")) {
            this.writer.writeElement("defaultTemplate", (String)parameters.get((Object)"defaulttemplate"));
        }
        if (parameters.containsKey((Object)"validationscript")) {
            this.writer.writeElement("validationScript", (String)parameters.get((Object)"validationscript"));
        }
        if (parameters.containsKey((Object)"revision_comment")) {
            this.writer.writeElement("comment", (String)parameters.get((Object)"revision_comment"));
        }
        if (parameters.containsKey((Object)"revision_minor")) {
            this.writer.writeElement("minorEdit", this.toString(parameters.get((Object)"revision_minor")));
        }
        if (parameters.containsKey((Object)"syntax")) {
            this.writer.writeElement("syntaxId", this.toString((Syntax)parameters.get((Object)"syntax")));
        }
        if (parameters.containsKey((Object)"hidden")) {
            this.writer.writeElement("hidden", this.toString(parameters.get((Object)"hidden")));
        }
        if (parameters.containsKey((Object)"content")) {
            this.writer.writeElement("content", (String)parameters.get((Object)"content"));
        }
        if (parameters.containsKey((Object)"content_html")) {
            this.writer.writeElement("renderedcontent", (String)parameters.get((Object)"content_html"));
        }
    }

    public void endWikiDocumentRevision(String version, FilterEventParameters parameters) throws WikiStreamException {
        this.currentDocumentVersion = null;
    }

    public void onWikiAttachment(String name, InputStream content, Long size, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeStartElement("attachment");
        this.writer.writeElement("filename", name);
        if (((XAROutputProperties)((Object)this.properties)).isPreserveVersion() && parameters.containsKey((Object)"xwiki_jrcsrevisions")) {
            this.writer.writeElement("versions", (String)parameters.get((Object)"xwiki_jrcsrevisions"));
        }
        if (parameters.containsKey((Object)"revision_author")) {
            this.writer.writeElement("author", (String)parameters.get((Object)"revision_author"));
        }
        if (parameters.containsKey((Object)"revision_date")) {
            this.writer.writeElement("date", this.toString((Date)parameters.get((Object)"revision_date")));
        }
        if (parameters.containsKey((Object)"revision")) {
            this.writer.writeElement("version", (String)parameters.get((Object)"revision"));
        }
        if (parameters.containsKey((Object)"revision_comment")) {
            this.writer.writeElement("comment", (String)parameters.get((Object)"revision_comment"));
        }
        if (content != null) {
            int readSize;
            long contentSize = 0L;
            this.writer.writeStartElement("content");
            byte[] buffer = new byte[4095];
            do {
                try {
                    readSize = content.read(buffer, 0, 4095);
                }
                catch (IOException e) {
                    throw new WikiStreamException("Failed to read content stream", (Throwable)e);
                }
                if (readSize <= 0) continue;
                String chunk = readSize == 4095 ? Base64.encodeBase64String((byte[])buffer) : Base64.encodeBase64String((byte[])ArrayUtils.subarray((byte[])buffer, (int)0, (int)readSize));
                this.writer.writeCharacters(chunk);
                contentSize += (long)readSize;
            } while (readSize == 4095);
            this.writer.writeEndElement();
            this.writer.writeElement("filesize", this.toString(contentSize));
        }
        this.writer.writeEndElement();
    }

    public void beginWikiClass(FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeStartElement("class");
        this.writer.writeElement("name", this.currentObjectClass != null ? this.currentObjectClass : (String)this.localSerializer.serialize((EntityReference)this.currentDocumentReference, new Object[0]));
        if (parameters.containsKey((Object)"customclass")) {
            this.writer.writeElement("customClass", (String)parameters.get((Object)"customclass"));
        }
        if (parameters.containsKey((Object)"custommapping")) {
            this.writer.writeElement("customMapping", (String)parameters.get((Object)"custommapping"));
        }
        if (parameters.containsKey((Object)"sheet_defaultview")) {
            this.writer.writeElement("defaultViewSheet", (String)parameters.get((Object)"sheet_defaultview"));
        }
        if (parameters.containsKey((Object)"sheet_defaultedit")) {
            this.writer.writeElement("defaultEditSheet", (String)parameters.get((Object)"sheet_defaultedit"));
        }
        if (parameters.containsKey((Object)"defaultspace")) {
            this.writer.writeElement("defaultWeb", (String)parameters.get((Object)"defaultspace"));
        }
        if (parameters.containsKey((Object)"namefield")) {
            this.writer.writeElement("nameField", (String)parameters.get((Object)"namefield"));
        }
        if (parameters.containsKey((Object)"validationscript")) {
            this.writer.writeElement("validationScript", (String)parameters.get((Object)"validationscript"));
        }
    }

    public void endWikiClass(FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeEndElement();
    }

    public void beginWikiClassProperty(String name, String type, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeStartElement(name);
        if (this.currentObjectProperties != null) {
            this.currentObjectProperties.put(name, type);
        }
    }

    public void endWikiClassProperty(String name, String type, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeElement("classType", type);
        this.writer.writeEndElement();
    }

    public void onWikiClassPropertyField(String name, String value, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeElement(name, value);
    }

    public void beginWikiObject(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeStartElement("object");
        this.currentObjectClass = (String)parameters.get((Object)"class_reference");
        this.writer.writeElement("name", (String)this.localSerializer.serialize((EntityReference)this.currentDocumentReference, new Object[0]));
        this.writer.writeElement("number", this.toString((Integer)parameters.get((Object)"number")));
        this.writer.writeElement("className", this.currentObjectClass);
        if (parameters.containsKey((Object)"guid")) {
            this.writer.writeElement("guid", (String)parameters.get((Object)"guid"));
        }
        this.currentObjectProperties = new HashMap<String, String>();
    }

    public void endWikiObject(String name, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeEndElement();
        this.currentObjectClass = null;
        this.currentObjectProperties = null;
    }

    public void onWikiObjectProperty(String name, Object value, FilterEventParameters parameters) throws WikiStreamException {
        this.writer.writeStartElement("property");
        this.writer.writeStartElement(name);
        try {
            this.propertySerializerManager.getPropertySerializer(this.currentObjectProperties.get(name)).write(this.writer.getWriter(), value);
        }
        catch (Exception e) {
            throw new WikiStreamException("Failed to write property value", (Throwable)e);
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }
}

