/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xar.internal.input;

import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.model.filter.WikiDocumentFilter;
import org.xwiki.wikistream.xar.input.XARInputProperties;
import org.xwiki.wikistream.xar.internal.input.DocumentLocaleReader;
import org.xwiki.wikistream.xar.internal.input.SkipEntityException;
import org.xwiki.wikistream.xar.internal.input.XARInputFilter;
import org.xwiki.xar.XarPackage;

@Component(roles={WikiReader.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiReader {
    private static final TranslationMarker LOG_DOCUMENT_SKIPPED = new TranslationMarker("wikistream.xar.log.document.skipped", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_SKIPPED});
    private static final TranslationMarker LOG_DOCUMENT_FAILREAD = new TranslationMarker("wikistream.xar.log.document.failread", new Marker[]{WikiDocumentFilter.LOG_DOCUMENT_ERROR});
    private static final TranslationMarker LOG_DESCRIPTOR_FAILREAD = new TranslationMarker("wikistream.xar.log.descriptor.failread");
    @Inject
    private DocumentLocaleReader documentReader;
    @Inject
    private Logger logger;
    private XARInputProperties properties;
    private XarPackage xarPackage = new XarPackage();

    public void setProperties(XARInputProperties properties) {
        this.properties = properties;
        this.documentReader.setProperties(properties);
    }

    public XarPackage getXarPackage() {
        return this.xarPackage;
    }

    public void read(Object filter, XARInputFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException {
        InputSource source = this.properties.getSource();
        if (!(source instanceof InputStreamInputSource)) {
            throw new WikiStreamException("Unsupported source type [" + source.getClass() + "]");
        }
        InputStream stream = ((InputStreamInputSource)source).getInputStream();
        this.read(stream, filter, proxyFilter);
        if (this.documentReader.getCurrentSpace() != null) {
            proxyFilter.endWikiSpace(this.documentReader.getCurrentSpace(), this.documentReader.getCurrentSpaceParameters());
        }
        if (this.xarPackage.getPackageExtensionId() != null) {
            proxyFilter.beginExtension(this.xarPackage.getPackageExtensionId(), this.xarPackage.getPackageVersion(), FilterEventParameters.EMPTY);
            proxyFilter.endExtension(this.xarPackage.getPackageExtensionId(), this.xarPackage.getPackageVersion(), FilterEventParameters.EMPTY);
        }
    }

    public void read(InputStream stream, Object filter, XARInputFilter proxyFilter) throws XMLStreamException, IOException, WikiStreamException {
        ZipArchiveInputStream zis = new ZipArchiveInputStream(stream, "UTF-8", false);
        ZipArchiveEntry entry = zis.getNextZipEntry();
        while (entry != null) {
            block10: {
                if (!entry.isDirectory() && !entry.getName().startsWith("META-INF")) {
                    if (entry.getName().equals("package.xml")) {
                        try {
                            this.xarPackage.readDescriptor((InputStream)zis);
                        }
                        catch (Exception e) {
                            if (this.properties.isVerbose()) {
                                this.logger.warn((Marker)LOG_DESCRIPTOR_FAILREAD, "Failed to read XAR descriptor from entry [{}]: {}", (Object)entry.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                            }
                            break block10;
                        }
                    }
                    try {
                        this.documentReader.read((InputStream)zis, filter, proxyFilter);
                    }
                    catch (SkipEntityException skip) {
                        if (this.properties.isVerbose()) {
                            this.logger.info((Marker)LOG_DOCUMENT_SKIPPED, "Skipped document [{}]", (Object)skip.getEntityReference());
                        }
                    }
                    catch (Exception e) {
                        if (!this.properties.isVerbose()) break block10;
                        this.logger.warn((Marker)LOG_DOCUMENT_FAILREAD, "Failed to read XAR XML document from entry [{}]: {}", (Object)entry.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                }
            }
            entry = zis.getNextZipEntry();
        }
    }
}

