/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.test.integration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.test.mockito.MockitoComponentManager;
import org.xwiki.wikistream.test.integration.TestConfiguration;
import org.xwiki.wikistream.test.integration.TestDataGenerator;
import org.xwiki.wikistream.test.integration.WikiStreamTest;

public class WikiStreamTestSuite
extends Suite {
    private static final TestDataGenerator GENERATOR = new TestDataGenerator();
    private static final String DEFAULT_PATTERN = ".*\\.test";
    private final Object klassInstance;
    private final ArrayList<Runner> runners = new ArrayList();

    public WikiStreamTestSuite(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        try {
            this.klassInstance = klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct instance of [" + klass.getName() + "]", e);
        }
        Scope scopeAnnotation = klass.getAnnotation(Scope.class);
        String packagePrefix = "";
        String pattern = DEFAULT_PATTERN;
        if (scopeAnnotation != null) {
            packagePrefix = scopeAnnotation.value();
            pattern = scopeAnnotation.pattern();
        }
        for (TestConfiguration testConfiguration : GENERATOR.generateData(packagePrefix, pattern)) {
            this.runners.add((Runner)new TestClassRunnerForParameters(WikiStreamTest.class, testConfiguration));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public Description getDescription() {
        return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final MockitoComponentManager mockitoComponentManager;
        private final TestConfiguration configuration;

        TestClassRunnerForParameters(Class<?> type, TestConfiguration configuration) throws InitializationError {
            super(type);
            this.mockitoComponentManager = new MockitoComponentManager();
            this.configuration = configuration;
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.configuration, this.getComponentManager());
        }

        protected String getName() {
            return this.configuration.name != null ? this.configuration.name : super.getName();
        }

        protected String testName(FrameworkMethod method) {
            return this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
            this.initializeComponentManager(notifier);
            try {
                for (Method klassMethod : WikiStreamTestSuite.this.klassInstance.getClass().getMethods()) {
                    Initialized componentManagerAnnotation = klassMethod.getAnnotation(Initialized.class);
                    if (componentManagerAnnotation == null) continue;
                    klassMethod.invoke(WikiStreamTestSuite.this.klassInstance, this.getComponentManager());
                }
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to call Component Manager initialization method", e)));
            }
            try {
                super.runChild(method, notifier);
            }
            finally {
                this.shutdownComponentManager(notifier);
            }
        }

        private void initializeComponentManager(RunNotifier notifier) {
            try {
                this.mockitoComponentManager.initializeTest(WikiStreamTestSuite.this.klassInstance);
                this.mockitoComponentManager.registerMemoryConfigurationSource();
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to initialize Component Manager", e)));
            }
        }

        private void shutdownComponentManager(RunNotifier notifier) {
            try {
                this.mockitoComponentManager.shutdownTest();
            }
            catch (Exception e) {
                notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)new RuntimeException("Failed to shutdown Component Manager", e)));
            }
        }

        private ComponentManager getComponentManager() throws Exception {
            return this.mockitoComponentManager;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Scope {
        public String value() default "";

        public String pattern() default ".*\\.test";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Initialized {
    }
}

