/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.test.integration;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.wikistream.input.ReaderInputSource;
import org.xwiki.wikistream.internal.output.ByteArrayOutputTarget;
import org.xwiki.wikistream.internal.output.StringWriterOutputTarget;
import org.xwiki.wikistream.output.OutputTarget;
import org.xwiki.wikistream.test.integration.ExpectTestConfiguration;
import org.xwiki.wikistream.test.integration.InputTestConfiguration;
import org.xwiki.wikistream.test.integration.OutputTestConfiguration;
import org.xwiki.wikistream.test.integration.TestConfiguration;
import org.xwiki.wikistream.test.integration.TestDataParser;
import org.xwiki.wikistream.test.integration.TestResourceData;

public class TestDataGenerator {
    private TestDataParser parser = new TestDataParser();

    public Collection<TestConfiguration> generateData(String testPackage, String pattern) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)ClasspathHelper.forPackage((String)"", (ClassLoader[])new ClassLoader[0])).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)testPackage))));
        ArrayList<TestConfiguration> data = new ArrayList<TestConfiguration>();
        for (String testResourceName : reflections.getResources(Pattern.compile(pattern))) {
            data.addAll(this.parseSingleResource(testResourceName));
        }
        return data;
    }

    private Collection<TestConfiguration> parseSingleResource(String testResourceName) {
        TestResourceData data;
        String resourceName = "/" + testResourceName;
        try {
            InputStream source = this.getClass().getResourceAsStream(resourceName);
            if (source == null) {
                throw new RuntimeException("Failed to find test file [" + resourceName + "]");
            }
            data = this.parser.parse(source, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read test data from [" + resourceName + "]", e);
        }
        ArrayList<TestConfiguration> result = new ArrayList<TestConfiguration>();
        for (InputTestConfiguration inputConfiguration : data.inputs) {
            for (ExpectTestConfiguration expectConfiguration : data.expects) {
                TestConfiguration testConfiguration = new TestConfiguration();
                testConfiguration.configuration = data.configuration;
                testConfiguration.inputConfiguration = new InputTestConfiguration(inputConfiguration);
                testConfiguration.expectConfiguration = new ExpectTestConfiguration(expectConfiguration);
                OutputTestConfiguration outputConfiguration = testConfiguration.expectConfiguration.output;
                if (outputConfiguration.getTarget() == null) {
                    if (testConfiguration.expectConfiguration.expect instanceof ReaderInputSource) {
                        outputConfiguration.setTarget((OutputTarget)new StringWriterOutputTarget());
                    } else {
                        outputConfiguration.setTarget((OutputTarget)new ByteArrayOutputTarget());
                    }
                }
                testConfiguration.name = this.computeTestName(testResourceName, inputConfiguration.typeId, expectConfiguration.output.typeId);
                result.add(testConfiguration);
            }
        }
        return result;
    }

    private String computeTestName(String prefix, String parserId, String targetSyntaxId) {
        return prefix + " [" + parserId + ", " + targetSyntaxId + "]";
    }
}

