/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.test.integration;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.test.internal.MockConfigurationSource;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.input.InputWikiStream;
import org.xwiki.wikistream.input.InputWikiStreamFactory;
import org.xwiki.wikistream.internal.output.ByteArrayOutputTarget;
import org.xwiki.wikistream.internal.output.StringWriterOutputTarget;
import org.xwiki.wikistream.output.OutputTarget;
import org.xwiki.wikistream.output.OutputWikiStream;
import org.xwiki.wikistream.output.OutputWikiStreamFactory;
import org.xwiki.wikistream.test.integration.TestConfiguration;

public class WikiStreamTest {
    private TestConfiguration configuration;
    private ComponentManager componentManager;

    public WikiStreamTest(TestConfiguration configuration, ComponentManager componentManager) {
        this.configuration = configuration;
        this.componentManager = componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void execute() throws Throwable {
        MockConfigurationSource mockConfigurationSource;
        ConfigurationSource configurationSource;
        HashMap<String, Object> originalConfiguration = new HashMap<String, Object>();
        if (this.configuration.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, String> entry : this.configuration.configuration.entrySet()) {
                originalConfiguration.put(entry.getKey(), mockConfigurationSource.getProperty(entry.getKey()));
                mockConfigurationSource.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        try {
            this.runTestInternal();
        }
        catch (Throwable throwable) {
            ConfigurationSource configurationSource2;
            if (this.configuration.configuration != null && (configurationSource2 = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
                MockConfigurationSource mockConfigurationSource2 = (MockConfigurationSource)configurationSource2;
                for (Map.Entry entry : originalConfiguration.entrySet()) {
                    if (entry.getValue() == null) {
                        mockConfigurationSource2.removeProperty((String)entry.getKey());
                        continue;
                    }
                    mockConfigurationSource2.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
            throw throwable;
        }
        if (this.configuration.configuration != null && (configurationSource = (ConfigurationSource)this.getComponentManager().getInstance(ConfigurationSource.class)) instanceof MockConfigurationSource) {
            mockConfigurationSource = (MockConfigurationSource)configurationSource;
            for (Map.Entry<String, String> entry : originalConfiguration.entrySet()) {
                if (entry.getValue() == null) {
                    mockConfigurationSource.removeProperty(entry.getKey());
                    continue;
                }
                mockConfigurationSource.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    private void runTestInternal() throws Throwable {
        InputWikiStreamFactory inputFactory = (InputWikiStreamFactory)this.getComponentManager().getInstance(InputWikiStreamFactory.class, this.configuration.inputConfiguration.typeId);
        OutputWikiStreamFactory outputFactory = (OutputWikiStreamFactory)this.getComponentManager().getInstance(OutputWikiStreamFactory.class, this.configuration.expectConfiguration.output.typeId);
        InputWikiStream inputWikiStream = inputFactory.createInputWikiStream((Map)this.configuration.inputConfiguration);
        OutputWikiStream outputWikiStream = outputFactory.createOutputWikiStream((Map)this.configuration.expectConfiguration.output);
        inputWikiStream.read(outputWikiStream.getFilter());
        inputWikiStream.close();
        outputWikiStream.close();
        this.assertExpectedResult(this.configuration.expectConfiguration.output.typeId, this.configuration.expectConfiguration.expect, this.configuration.expectConfiguration.output.getTarget());
    }

    private void assertExpectedResult(String typeId, InputSource expect, OutputTarget actual) throws IOException {
        if (actual instanceof StringWriterOutputTarget) {
            Assert.assertEquals((Object)expect.toString(), (Object)actual.toString());
        } else if (actual instanceof ByteArrayOutputTarget) {
            byte[] actualBytes = ((ByteArrayOutputTarget)actual).toByteArray();
            byte[] expectBytes = IOUtils.toByteArray((InputStream)((InputStreamInputSource)expect).getInputStream());
            Assert.assertArrayEquals((byte[])expectBytes, (byte[])actualBytes);
        } else {
            Assert.fail((String)("Output target type [" + actual.getClass() + "] is not supported"));
        }
    }

    public ComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }
}

