/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.xml.internal.output;

import java.io.IOException;

import javax.xml.transform.Result;

import org.xwiki.wikistream.xml.output.ResultOutputTarget;

/**
 * @version $Id: 0a9a44702369fce9d08e5d0147079689a2ec0cd4 $
 * @since 5.2M2
 */
public class DefaultResultInputSource implements ResultOutputTarget
{
    private Result result;

    public DefaultResultInputSource(Result result)
    {
        this.result = result;
    }

    @Override
    public boolean restartSupported()
    {
        return false;
    }

    @Override
    public void close() throws IOException
    {
        // Result is not closable
    }

    @Override
    public Result getResult()
    {
        return this.result;
    }
}
