/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xml.internal.output;

import java.io.IOException;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.output.OutputStreamOutputTarget;
import org.xwiki.wikistream.output.OutputTarget;
import org.xwiki.wikistream.output.WriterOutputTarget;
import org.xwiki.wikistream.xml.output.ResultOutputTarget;
import org.xwiki.wikistream.xml.output.XMLOutputProperties;
import org.xwiki.xml.stax.StAXUtils;

public final class XMLOutputWikiStreamUtils {
    public static XMLStreamWriter createXMLStreamWriter(XMLOutputProperties properties) throws XMLStreamException, IOException, WikiStreamException {
        XMLStreamWriter xmlStreamWriter;
        OutputTarget target = properties.getTarget();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (target instanceof WriterOutputTarget) {
            xmlStreamWriter = factory.createXMLStreamWriter(((WriterOutputTarget)target).getWriter());
        } else if (target instanceof OutputStreamOutputTarget) {
            xmlStreamWriter = factory.createXMLStreamWriter(((OutputStreamOutputTarget)target).getOutputStream(), properties.getEncoding());
        } else if (target instanceof ResultOutputTarget) {
            xmlStreamWriter = StAXUtils.getXMLStreamWriter((Result)((ResultOutputTarget)target).getResult());
        } else {
            throw new WikiStreamException("Unknown target type [" + target.getClass() + "]");
        }
        if (properties.isFormat()) {
            xmlStreamWriter = new IndentingXMLStreamWriter(xmlStreamWriter);
        }
        return xmlStreamWriter;
    }
}

