/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wikistream.xml.internal.input;

import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.input.InputSource;
import org.xwiki.wikistream.input.InputStreamInputSource;
import org.xwiki.wikistream.input.ReaderInputSource;
import org.xwiki.wikistream.xml.input.SourceInputSource;
import org.xwiki.wikistream.xml.input.XMLInputProperties;
import org.xwiki.xml.stax.StAXUtils;

public final class XMLInputWikiStreamUtils {
    public static XMLEventReader createXMLEventReader(XMLInputProperties properties) throws XMLStreamException, IOException, WikiStreamException {
        XMLEventReader xmlEventReader;
        InputSource source = properties.getSource();
        if (source instanceof ReaderInputSource) {
            xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((ReaderInputSource)source).getReader());
        } else if (source instanceof InputStreamInputSource) {
            xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(((InputStreamInputSource)source).getInputStream());
        } else if (source instanceof SourceInputSource) {
            xmlEventReader = StAXUtils.getXMLEventReader((Source)((SourceInputSource)source).getSource());
        } else {
            throw new WikiStreamException("Unknown source type [" + source.getClass() + "]");
        }
        return xmlEventReader;
    }

    public static XMLStreamReader createXMLStreamReader(XMLInputProperties properties) throws XMLStreamException, IOException, WikiStreamException {
        XMLStreamReader xmlStreamReader;
        InputSource source = properties.getSource();
        if (source instanceof ReaderInputSource) {
            xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(((ReaderInputSource)source).getReader());
        } else if (source instanceof InputStreamInputSource) {
            xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(((InputStreamInputSource)source).getInputStream());
        } else if (source instanceof SourceInputSource) {
            xmlStreamReader = StAXUtils.getXMLStreamReader((Source)((SourceInputSource)source).getSource());
        } else {
            throw new WikiStreamException("Unknown source type [" + source.getClass() + "]");
        }
        return xmlStreamReader;
    }
}

