/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.wikistream.xml.internal.output;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;

import org.xwiki.wikistream.WikiStreamException;
import org.xwiki.wikistream.internal.output.AbstractBeanOutputWikiStreamFactory;
import org.xwiki.wikistream.internal.output.BeanOutputWikiStream;
import org.xwiki.wikistream.type.WikiStreamType;
import org.xwiki.wikistream.xml.output.XMLOutputProperties;

/**
 * A generic xml output wikistream implementation. This class can be used as a test bench to validate various
 * XMLInputStream wiki parsers.
 * 
 * @version $Id: 49ec5ea76d9dcac538c7dd1bea8de09efafb1c4b $
 * @since 5.2M2
 */
public abstract class AbstractXMLBeanOutputWikiStreamFactory<P extends XMLOutputProperties, F> extends
    AbstractBeanOutputWikiStreamFactory<P, F>
{
    public AbstractXMLBeanOutputWikiStreamFactory(WikiStreamType type)
    {
        super(type);
    }

    @Override
    public BeanOutputWikiStream<P> createOutputWikiStream(P properties) throws WikiStreamException
    {
        try {
            return new DefaultXMLOutputWikiStream<P, F>(this, properties);
        } catch (Exception e) {
            throw new WikiStreamException("Failed to create output wiki stream", e);
        }
    }

    protected abstract Object createListener(Result result, P parameters) throws XMLStreamException,
        FactoryConfigurationError, WikiStreamException;
}
