/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.wysiwyg.internal.cleaner;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.wysiwyg.internal.cleaner.AbstractHTMLFilter;
import org.xwiki.wysiwyg.internal.cleaner.HTMLFilter;

@Component(roles={HTMLFilter.class})
@Named(value="emptyAttribute")
@Singleton
public class EmptyAttributeFilter
extends AbstractHTMLFilter {
    @Inject
    private Logger logger;

    public void filter(Document document, Map<String, String> parameters) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList emptyAttributes = (NodeList)xpath.compile("//@*[. = '']").evaluate(document, XPathConstants.NODESET);
            for (int i = emptyAttributes.getLength() - 1; i >= 0; --i) {
                Attr emptyAttribute = (Attr)emptyAttributes.item(i);
                emptyAttribute.getOwnerElement().removeAttributeNode(emptyAttribute);
            }
        }
        catch (XPathExpressionException e) {
            this.logger.error("Exception while filtering empty attributes.", (Throwable)e);
        }
    }
}

