/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AbstractExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;

public class WikiPageExplorerWizardStep
extends AbstractExplorerWizardStep {
    public WikiPageExplorerWizardStep() {
        super(true, false, false, 455, 280);
        this.setStepTitle(Strings.INSTANCE.linkSelectWikipageTitle());
        this.setHelpLabelText(Strings.INSTANCE.linkSelectWikipageHelpLabel());
    }

    public String getNextStep() {
        WikiPageReference wikiPageReference = new WikiPageReference(((EntityLink)this.getData()).getDestination().getEntityReference());
        return StringUtils.isEmpty((String)wikiPageReference.getPageName()) ? LinkWizard.LinkWizardStep.WIKI_PAGE_CREATOR.toString() : LinkWizard.LinkWizardStep.LINK_CONFIG.toString();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.hideError();
        WikiPageReference pageReference = new WikiPageReference();
        pageReference.setWikiName(this.getExplorer().getSelectedWiki());
        pageReference.setSpaceName(this.getExplorer().getSelectedSpace());
        pageReference.setPageName(this.getExplorer().getSelectedPage());
        if (this.getExplorer().isNewPageSelectedFromTreeNode()) {
            ((LinkConfig)((EntityLink)this.getData()).getData()).setType(LinkConfig.LinkType.NEW_WIKIPAGE);
            ((EntityLink)this.getData()).getDestination().setEntityReference(pageReference.getEntityReference());
            async.onSuccess((Object)true);
        } else if (StringUtils.isEmpty((String)pageReference.getPageName())) {
            this.displayError(Strings.INSTANCE.linkNoPageSelectedError());
            async.onSuccess((Object)false);
        } else if (!StringUtils.isEmpty((String)((LinkConfig)((EntityLink)this.getData()).getData()).getReference()) && ((EntityLink)this.getData()).getDestination().getEntityReference().equals(pageReference.getEntityReference())) {
            async.onSuccess((Object)true);
        } else {
            this.updateLinkConfig(pageReference.getEntityReference());
            LinkConfig.LinkType linkType = this.getExplorer().isNewPage() ? LinkConfig.LinkType.NEW_WIKIPAGE : LinkConfig.LinkType.WIKIPAGE;
            ((LinkConfig)((EntityLink)this.getData()).getData()).setType(linkType);
            async.onSuccess((Object)true);
        }
    }
}

