/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.dom.client.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroCall;

public class MacroDisplayer
implements InnerHTMLListener {
    public static final String MACRO_STYLE_NAME = "macro";
    public static final String SELECTED_MACRO_STYLE_NAME = "macro-selected";
    public static final String BLOCK_MACRO_STYLE_NAME = "macro-block";
    public static final String INLINE_MACRO_STYLE_NAME = "macro-inline";
    public static final String COLLAPSED_MACRO_STYLE_NAME = "macro-collapsed";
    public static final String START_MACRO_COMMENT_PREFIX = "startmacro:";
    public static final String STOP_MACRO_COMMENT_VALUE = "stopmacro";
    protected final DOMUtils domUtils = DOMUtils.getInstance();
    private final RichTextArea textArea;

    public MacroDisplayer(RichTextArea textArea) {
        this.textArea = textArea;
        textArea.getDocument().addInnerHTMLListener((InnerHTMLListener)this);
        this.display(this.getStartMacroCommentNodes((Node)textArea.getDocument().getBody()));
    }

    public void destroy() {
        this.textArea.getDocument().removeInnerHTMLListener((InnerHTMLListener)this);
    }

    public RichTextArea getTextArea() {
        return this.textArea;
    }

    private void display(List<Node> startMacroComments) {
        for (Node start : startMacroComments) {
            this.display(start);
        }
    }

    private void display(Node start) {
        Element container;
        Node stop = start.getNextSibling();
        int siblingCount = 0;
        int openedMacrosCount = 0;
        while (stop != null) {
            if (stop.getNodeType() == 8) {
                if (stop.getNodeValue().startsWith(START_MACRO_COMMENT_PREFIX)) {
                    ++openedMacrosCount;
                } else if (STOP_MACRO_COMMENT_VALUE.equals(stop.getNodeValue())) {
                    if (openedMacrosCount == 0) break;
                    --openedMacrosCount;
                }
            }
            stop = stop.getNextSibling();
            ++siblingCount;
        }
        if (stop == null) {
            return;
        }
        if (siblingCount == 1 && this.isMacroContainer(start.getNextSibling())) {
            container = (Element)start.getNextSibling();
        } else {
            container = this.createMacroContainer(start, stop, siblingCount);
            this.setCollapsed(container, false);
        }
        container.setMetaData(this.extractMetaData(start, stop));
        this.setSelected(container, false);
    }

    protected Element createMacroContainer(Node start, Node stop, int siblingCount) {
        boolean inLine = this.isInLine(start, stop, siblingCount);
        Element container = this.createReadOnlyBox(inLine);
        container.addClassName(MACRO_STYLE_NAME);
        container.addClassName(inLine ? INLINE_MACRO_STYLE_NAME : BLOCK_MACRO_STYLE_NAME);
        MacroCall call = new MacroCall(start.getNodeValue());
        container.setTitle(call.getName() + " macro");
        container.appendChild((Node)this.createPlaceHolder(call));
        if (siblingCount > 0) {
            int startIndex = this.domUtils.getNodeIndex(start);
            int endIndex = startIndex + siblingCount + 1;
            Document doc = this.textArea.getDocument();
            Element output = Element.as((Node)(inLine ? doc.createSpanElement() : doc.createDivElement()));
            output.appendChild((Node)this.domUtils.extractNodeContents(start.getParentNode(), startIndex + 1, endIndex));
            output.setClassName("macro-output");
            container.appendChild((Node)output);
        }
        start.getParentNode().insertBefore((Node)container, start);
        return container;
    }

    private boolean isInLine(Node start, Node stop, int siblingCount) {
        if (siblingCount > 0) {
            for (Node sibling = start.getNextSibling(); sibling != stop; sibling = sibling.getNextSibling()) {
                if (!this.domUtils.isBlock(sibling)) continue;
                return false;
            }
            return true;
        }
        return !this.domUtils.isFlowContainer(start.getParentNode());
    }

    protected Element createReadOnlyBox(boolean inLine) {
        Document doc = this.textArea.getDocument();
        Element container = Element.as((Node)(inLine ? doc.createSpanElement() : doc.createDivElement()));
        container.setClassName("readOnly");
        return container;
    }

    private List<Node> getStartMacroCommentNodes(Node root) {
        Document document = (Document)root.getOwnerDocument();
        Iterator iterator = document.getIterator(root);
        ArrayList<Node> startMacroComments = new ArrayList<Node>();
        int openedMacrosCount = 0;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 8) continue;
            if (node.getNodeValue().startsWith(START_MACRO_COMMENT_PREFIX)) {
                if (openedMacrosCount == 0) {
                    startMacroComments.add(node);
                }
                ++openedMacrosCount;
                continue;
            }
            if (!STOP_MACRO_COMMENT_VALUE.equals(node.getNodeValue())) continue;
            --openedMacrosCount;
        }
        return startMacroComments;
    }

    private DocumentFragment createPlaceHolder(MacroCall call) {
        Document document = this.textArea.getDocument();
        Element macroIcon = Element.as((Node)document.createSpanElement());
        macroIcon.setClassName("macro-icon");
        macroIcon.appendChild((Node)document.createTextNode("\u00a0"));
        Element placeHolder = (Element)document.createSpanElement().cast();
        placeHolder.appendChild((Node)macroIcon);
        placeHolder.appendChild((Node)document.createTextNode(call.getName()));
        placeHolder.setClassName("macro-placeholder");
        DocumentFragment output = document.createDocumentFragment();
        output.appendChild((Node)placeHolder);
        return output;
    }

    private DocumentFragment extractMetaData(Node start, Node stop) {
        DocumentFragment metaData = this.textArea.getDocument().createDocumentFragment();
        metaData.appendChild(start);
        metaData.appendChild(stop);
        return metaData;
    }

    public void setSelected(Element container, boolean selected) {
        if (selected) {
            container.addClassName(SELECTED_MACRO_STYLE_NAME);
        } else {
            container.removeClassName(SELECTED_MACRO_STYLE_NAME);
        }
    }

    public boolean isSelected(Element container) {
        return container.hasClassName(SELECTED_MACRO_STYLE_NAME);
    }

    public boolean isMacroContainer(Node node) {
        if (!Element.is((Node)node)) {
            return false;
        }
        Element element = Element.as((Node)node);
        return element.hasClassName(MACRO_STYLE_NAME) && element.hasAttribute("metadata") && element.getAttribute("metadata").startsWith(START_MACRO_COMMENT_PREFIX, 4);
    }

    public List<Element> getMacroContainers(Element root) {
        Element node = root;
        ArrayList<Element> containers = new ArrayList<Element>();
        while (true) {
            boolean isMacroContainer = this.isMacroContainer((Node)node);
            if (!node.hasChildNodes() || isMacroContainer) {
                if (isMacroContainer) {
                    containers.add(Element.as((Node)node));
                }
                while (node != root && node.getNextSibling() == null) {
                    node = node.getParentNode();
                }
                if (node == root) break;
                node = node.getNextSibling();
                continue;
            }
            node = node.getFirstChild();
        }
        return containers;
    }

    public void setCollapsed(Element container, boolean collapsed) {
        boolean collapse;
        Element output = this.getOutput(container);
        boolean bl = collapse = collapsed || output == null;
        if (collapse) {
            container.addClassName(COLLAPSED_MACRO_STYLE_NAME);
        } else {
            container.removeClassName(COLLAPSED_MACRO_STYLE_NAME);
        }
    }

    public boolean isCollapsed(Element container) {
        return container.hasClassName(COLLAPSED_MACRO_STYLE_NAME);
    }

    protected Element getOutput(Element container) {
        return (Element)this.getPlaceHolder(container).getNextSibling();
    }

    public boolean hasOutput(Element container) {
        return this.getOutput(container) != null;
    }

    protected Element getPlaceHolder(Element container) {
        return (Element)container.getFirstChild();
    }

    public void onInnerHTMLChange(Element element) {
        if (element.getOwnerDocument() == this.textArea.getDocument()) {
            this.display(this.getStartMacroCommentNodes((Node)element));
        }
    }

    public String getSerializedMacroCall(Element container) {
        return container.getMetaData().getFirstChild().getNodeValue();
    }
}

