/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.AbstractInteractiveWizardStep;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.AttachmentReference;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.URIReference;

public class ImageConfigWizardStep
extends AbstractInteractiveWizardStep
implements KeyPressHandler,
SourcesNavigationEvents {
    private static final String INFO_LABEL_STYLE = "xInfoLabel";
    private static final String HELP_LABEL_STYLE = "xHelpLabel";
    private EntityLink<ImageConfig> entityLink;
    private final NavigationListenerCollection navigationListeners = new NavigationListenerCollection();
    private List<RadioButton> alignmentOptions;
    private TextBox widthBox;
    private TextBox heightBox;
    private TextBox altTextBox;

    public ImageConfigWizardStep() {
        this.setStepTitle(Strings.INSTANCE.imageConfigTitle());
        this.display().addStyleName("xImageConfig");
        this.display().add((Widget)this.getSizePanel());
        this.display().add((Widget)this.getAltTextPanel());
        this.display().add((Widget)this.getAlignmentPanel());
    }

    private Panel getSizePanel() {
        this.widthBox = new TextBox();
        this.widthBox.addKeyPressHandler((KeyPressHandler)this);
        this.heightBox = new TextBox();
        this.heightBox.addKeyPressHandler((KeyPressHandler)this);
        FlowPanel sizePanel = new FlowPanel();
        sizePanel.addStyleName("xSizePanel");
        Label widthLabel = new Label(Strings.INSTANCE.imageWidthLabel());
        widthLabel.setStyleName(INFO_LABEL_STYLE);
        Label widthHelpLabel = new Label(Strings.INSTANCE.imageWidthHelpLabel());
        widthHelpLabel.setStyleName(HELP_LABEL_STYLE);
        sizePanel.add((Widget)widthLabel);
        sizePanel.add((Widget)widthHelpLabel);
        sizePanel.add((Widget)this.widthBox);
        Label heightLabel = new Label(Strings.INSTANCE.imageHeightLabel());
        heightLabel.setStyleName(INFO_LABEL_STYLE);
        Label heightHelpLabel = new Label(Strings.INSTANCE.imageHeightHelpLabel());
        heightHelpLabel.setStyleName(HELP_LABEL_STYLE);
        sizePanel.add((Widget)heightLabel);
        sizePanel.add((Widget)heightHelpLabel);
        sizePanel.add((Widget)this.heightBox);
        return sizePanel;
    }

    private Panel getAltTextPanel() {
        this.altTextBox = new TextBox();
        this.altTextBox.addKeyPressHandler((KeyPressHandler)this);
        Label altTextLabel = new Label(Strings.INSTANCE.imageAltTextLabel());
        altTextLabel.setStyleName(INFO_LABEL_STYLE);
        Label altTextHelpLabel = new Label(Strings.INSTANCE.imageAltTextHelpLabel());
        altTextHelpLabel.setStyleName(HELP_LABEL_STYLE);
        FlowPanel altTextPanel = new FlowPanel();
        altTextPanel.addStyleName("xAltPanel");
        altTextPanel.add((Widget)altTextLabel);
        altTextPanel.add((Widget)altTextHelpLabel);
        altTextPanel.add((Widget)this.altTextBox);
        return altTextPanel;
    }

    private Panel getAlignmentPanel() {
        FlowPanel alignmentPanel = new FlowPanel();
        String alignRadioGroup = "alignment";
        alignmentPanel.add((Widget)this.getHorizontalAlignmentPanel(alignRadioGroup));
        alignmentPanel.add((Widget)this.getVerticalAlignmentPanel(alignRadioGroup));
        return alignmentPanel;
    }

    private Panel getHorizontalAlignmentPanel(String alignRadioGroup) {
        FlowPanel hAlignPanel = new FlowPanel();
        Label hAlignLabel = new Label(Strings.INSTANCE.imageHorizontalAlignmentLabel());
        hAlignLabel.setStyleName(INFO_LABEL_STYLE);
        Label hAlignHelpLabel = new Label(Strings.INSTANCE.imageHorizontalAlignmentHelpLabel());
        hAlignHelpLabel.setStyleName(HELP_LABEL_STYLE);
        hAlignPanel.addStyleName("xHAlignPanel");
        hAlignPanel.add((Widget)hAlignLabel);
        hAlignPanel.add((Widget)hAlignHelpLabel);
        this.alignmentOptions = new ArrayList<RadioButton>();
        RadioButton leftRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignLeftLabel());
        leftRadio.setFormValue(ImageConfig.ImageAlignment.LEFT.toString());
        leftRadio.addKeyPressHandler((KeyPressHandler)this);
        RadioButton centerRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignCenterLabel());
        centerRadio.setFormValue(ImageConfig.ImageAlignment.CENTER.toString());
        centerRadio.addKeyPressHandler((KeyPressHandler)this);
        RadioButton rightRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignRightLabel());
        rightRadio.setFormValue(ImageConfig.ImageAlignment.RIGHT.toString());
        rightRadio.addKeyPressHandler((KeyPressHandler)this);
        this.alignmentOptions.add(leftRadio);
        this.alignmentOptions.add(centerRadio);
        this.alignmentOptions.add(rightRadio);
        hAlignPanel.add((Widget)leftRadio);
        hAlignPanel.add((Widget)centerRadio);
        hAlignPanel.add((Widget)rightRadio);
        return hAlignPanel;
    }

    private Panel getVerticalAlignmentPanel(String alignRadioGroup) {
        FlowPanel vAlignPanel = new FlowPanel();
        Label vAlignLabel = new Label(Strings.INSTANCE.imageVerticalAlignmentLabel());
        vAlignLabel.setStyleName(INFO_LABEL_STYLE);
        Label vAlignHelpLabel = new Label(Strings.INSTANCE.imageVerticalAlignmentHelpLabel());
        vAlignHelpLabel.setStyleName(HELP_LABEL_STYLE);
        vAlignPanel.addStyleName("xVAlignPanel");
        vAlignPanel.add((Widget)vAlignLabel);
        vAlignPanel.add((Widget)vAlignHelpLabel);
        RadioButton topRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignTopLabel());
        topRadio.setFormValue(ImageConfig.ImageAlignment.TOP.toString());
        topRadio.addKeyPressHandler((KeyPressHandler)this);
        RadioButton middleRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignMiddleLabel());
        middleRadio.setFormValue(ImageConfig.ImageAlignment.MIDDLE.toString());
        middleRadio.addKeyPressHandler((KeyPressHandler)this);
        RadioButton bottomRadio = new RadioButton(alignRadioGroup, Strings.INSTANCE.imageAlignBottomLabel());
        bottomRadio.setFormValue(ImageConfig.ImageAlignment.BOTTOM.toString());
        bottomRadio.addKeyPressHandler((KeyPressHandler)this);
        this.alignmentOptions.add(topRadio);
        this.alignmentOptions.add(middleRadio);
        this.alignmentOptions.add(bottomRadio);
        vAlignPanel.add((Widget)topRadio);
        vAlignPanel.add((Widget)middleRadio);
        vAlignPanel.add((Widget)bottomRadio);
        return vAlignPanel;
    }

    public ImageConfig.ImageAlignment getSelectedAlignment() {
        for (RadioButton rb : this.alignmentOptions) {
            if (!rb.getValue().booleanValue()) continue;
            return ImageConfig.ImageAlignment.valueOf(rb.getFormValue());
        }
        return null;
    }

    protected void setImageAlignment(ImageConfig.ImageAlignment alignment) {
        String alignValue = alignment != null ? alignment.toString() : "";
        for (RadioButton rb : this.alignmentOptions) {
            if (rb.getFormValue().equals(alignValue)) {
                rb.setValue(Boolean.valueOf(true));
                continue;
            }
            rb.setValue(Boolean.valueOf(false));
        }
    }

    public void init(Object data, AsyncCallback<?> cb) {
        this.entityLink = (EntityLink)data;
        this.widthBox.setText(this.entityLink.getData().getWidth());
        this.heightBox.setText(this.entityLink.getData().getHeight());
        this.setImageAlignment(this.entityLink.getData().getAlignment());
        String altText = this.entityLink.getData().getAltText();
        if (StringUtils.isEmpty((String)altText)) {
            switch (this.entityLink.getDestination().getEntityReference().getType()) {
                case ATTACHMENT: {
                    altText = new AttachmentReference(this.entityLink.getDestination().getEntityReference()).getFileName();
                    break;
                }
                case EXTERNAL: {
                    altText = new URIReference(this.entityLink.getDestination().getEntityReference()).getURI();
                    break;
                }
                default: {
                    altText = "";
                }
            }
        }
        this.altTextBox.setText(altText);
        cb.onSuccess(null);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new FocusCommand((Focusable)this.widthBox));
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        String altText = this.altTextBox.getText().trim();
        AttachmentReference imageReference = new AttachmentReference(this.entityLink.getDestination().getEntityReference());
        this.entityLink.getData().setAltText(altText.length() > 0 ? altText : imageReference.getFileName());
        this.entityLink.getData().setWidth(this.widthBox.getText().trim());
        this.entityLink.getData().setHeight(this.heightBox.getText().trim());
        ImageConfig.ImageAlignment alignment = this.getSelectedAlignment();
        this.entityLink.getData().setAlignment(alignment);
        async.onSuccess((Object)true);
    }

    public void onCancel() {
    }

    public Object getResult() {
        return this.entityLink;
    }

    public NavigationListener.NavigationDirection getDefaultDirection() {
        return NavigationListener.NavigationDirection.FINISH;
    }

    public void addNavigationListener(NavigationListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getNativeEvent().getKeyCode() == 13) {
            this.navigationListeners.fireNavigationEvent(this.getDefaultDirection());
        }
    }
}

