/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.importer.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.importer.ImportServiceAsync;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractFileUploadWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPageReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

public class ImportOfficeFileWizardStep
extends AbstractFileUploadWizardStep {
    private Object result;
    private CheckBox filterStylesCheckBox;
    private final ImportServiceAsync importService;
    private final WikiPageReference targetPageReference;

    public ImportOfficeFileWizardStep(Config config, WikiServiceAsync wikiService, ImportServiceAsync importService) {
        super(wikiService);
        this.importService = importService;
        boolean isOpenOfficeServerConnected = Boolean.valueOf(config.getParameter("openofficeServerConnected", "false"));
        this.setStepTitle(Strings.INSTANCE.importOfficeFileWizardStepTitle());
        this.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.importWizardImportButtonCaption());
        this.setValidDirections(isOpenOfficeServerConnected ? EnumSet.of(NavigationListener.NavigationDirection.CANCEL, NavigationListener.NavigationDirection.FINISH) : EnumSet.of(NavigationListener.NavigationDirection.CANCEL));
        this.targetPageReference = new WikiPageReference();
        this.targetPageReference.setWikiName(config.getParameter("wiki", "xwiki"));
        this.targetPageReference.setSpaceName(config.getParameter("space", "Main"));
        this.targetPageReference.setPageName(config.getParameter("page", "WebHome"));
        if (isOpenOfficeServerConnected) {
            this.setFileHelpLabel(Strings.INSTANCE.importOfficeFileHelpLabel());
            this.filterStylesCheckBox = new CheckBox(Strings.INSTANCE.importOfficeContentFilterStylesCheckBoxLabel());
            this.filterStylesCheckBox.setValue(Boolean.valueOf(true));
            this.display().add((Widget)this.filterStylesCheckBox);
        } else {
            Label errorMessageLabel = new Label(Strings.INSTANCE.importOfficeFileFeatureNotAvailable());
            errorMessageLabel.addStyleName("xErrorMsg");
            this.display().clear();
            this.display().add((Widget)errorMessageLabel);
        }
    }

    @Override
    protected void onAttachmentUploaded(Attachment attach, final AsyncCallback<Boolean> async) {
        this.importService.officeToXHTML(attach, this.getHTMLCleaningParams(), new AsyncCallback<String>(){

            public void onSuccess(String result) {
                ImportOfficeFileWizardStep.this.result = result;
                async.onSuccess((Object)true);
            }

            public void onFailure(Throwable thrown) {
                ImportOfficeFileWizardStep.this.displayError(thrown.getMessage());
                async.onSuccess((Object)false);
            }
        });
    }

    public Object getResult() {
        return this.result;
    }

    protected Map<String, String> getHTMLCleaningParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.filterStylesCheckBox.getValue().booleanValue()) {
            params.put("filterStyles", "strict");
        }
        params.put("namespacesAware", Boolean.toString(false));
        return params;
    }

    @Override
    protected WikiPageReference getTargetPageReference() {
        return this.targetPageReference;
    }
}

