/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.filter.HiddenElements;
import org.xwiki.gwt.dom.client.filter.NodeFilter;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;

public class EmptyLinkFilter
implements CommandListener {
    private static final Command SUBMIT = new Command("submit");
    private static final NodeFilter HIDDEN = new HiddenElements();
    private RichTextArea rta;

    public EmptyLinkFilter(RichTextArea rta) {
        this.rta = rta;
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        if (SUBMIT.equals((Object)command) && this.rta.isAttached() && this.rta.getElement().getOffsetWidth() > 0) {
            for (Element anchor : this.getEmptyAnchors()) {
                anchor.getParentNode().removeChild((Node)anchor);
            }
        }
        return false;
    }

    private List<Element> getEmptyAnchors() {
        ArrayList<Element> emptyAnchors = new ArrayList<Element>();
        NodeList anchorsList = this.rta.getDocument().getElementsByTagName("a");
        for (int i = 0; i < anchorsList.getLength(); ++i) {
            Element anchor = (Element)anchorsList.getItem(i);
            if (!this.isEmpty(AnchorElement.as((Element)anchor))) continue;
            emptyAnchors.add(anchor);
        }
        return emptyAnchors;
    }

    private boolean isEmpty(AnchorElement anchor) {
        return !StringUtils.isEmpty((String)anchor.getHref()) && this.isDisplayed((Element)anchor) && !this.isVisible((Element)anchor);
    }

    private boolean isVisible(Element element) {
        Iterator iterator = ((Document)element.getOwnerDocument()).getIterator((Node)element);
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!Element.is((Node)node) || Element.as((Node)node).getOffsetWidth() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isDisplayed(Element element) {
        return DOMUtils.getInstance().getFirstAncestor((Node)element, HIDDEN) == null;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
    }
}

