/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.user.client.ui.Image;
import java.util.ArrayList;
import java.util.EnumSet;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.Wizard;
import org.xwiki.gwt.user.client.ui.wizard.WizardListener;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepMap;
import org.xwiki.gwt.user.client.ui.wizard.WizardStepProvider;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroCall;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDisplayer;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ui.EditMacroWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.ui.SelectMacroWizardStep;

public class MacroWizard
implements WizardListener {
    public static final Command INSERT = new Command("macroInsert");
    private static final String EDIT_STEP_NAME = "edit";
    private static final String SELECT_STEP_NAME = "select";
    private Wizard editWizard;
    private Wizard insertWizard;
    private final MacroDisplayer displayer;
    private final Config config;
    private final MacroServiceAsync macroService;

    public MacroWizard(MacroDisplayer displayer, Config config, MacroServiceAsync macroService) {
        this.displayer = displayer;
        this.config = config;
        this.macroService = macroService;
    }

    public void edit() {
        this.getEditWizard().start(EDIT_STEP_NAME, (Object)new MacroCall(this.displayer.getTextArea().getCommandManager().getStringValue(INSERT)));
    }

    public void insert() {
        ArrayList<String> usedMacroIds = new ArrayList<String>();
        Element root = (Element)this.displayer.getTextArea().getDocument().getBody().cast();
        for (Element container : this.displayer.getMacroContainers(root)) {
            usedMacroIds.add(new MacroCall(this.displayer.getSerializedMacroCall(container)).getName());
        }
        this.getInsertWizard().start(SELECT_STEP_NAME, usedMacroIds);
    }

    public void insert(String macroId) {
        MacroCall macroCall = new MacroCall();
        macroCall.setName(macroId);
        this.getInsertWizard().start(EDIT_STEP_NAME, (Object)macroCall);
    }

    public void onCancel(Wizard sender) {
        this.displayer.getTextArea().setFocus(true);
    }

    public void onFinish(Wizard sender, Object result) {
        this.displayer.getTextArea().setFocus(true);
        this.displayer.getTextArea().getCommandManager().execute(INSERT, ((MacroCall)result).toString());
    }

    private Wizard getEditWizard() {
        if (this.editWizard == null) {
            EditMacroWizardStep editStep = new EditMacroWizardStep(this.config, this.macroService);
            editStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.apply());
            editStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.FINISH));
            WizardStepMap editSteps = new WizardStepMap();
            editSteps.put((Object)EDIT_STEP_NAME, (Object)editStep);
            this.editWizard = new Wizard(Strings.INSTANCE.macroEditDialogCaption(), new Image(Images.INSTANCE.macroEdit()));
            this.editWizard.setProvider((WizardStepProvider)editSteps);
            this.editWizard.addWizardListener((WizardListener)this);
        }
        return this.editWizard;
    }

    private Wizard getInsertWizard() {
        if (this.insertWizard == null) {
            SelectMacroWizardStep selectStep = new SelectMacroWizardStep(this.config, this.macroService);
            selectStep.setNextStep(EDIT_STEP_NAME);
            selectStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.NEXT));
            selectStep.setDirectionName(NavigationListener.NavigationDirection.NEXT, Strings.INSTANCE.select());
            EditMacroWizardStep editStep = new EditMacroWizardStep(this.config, this.macroService);
            editStep.setDirectionName(NavigationListener.NavigationDirection.FINISH, Strings.INSTANCE.macroInsertActionLabel());
            editStep.setValidDirections(EnumSet.of(NavigationListener.NavigationDirection.PREVIOUS, NavigationListener.NavigationDirection.FINISH));
            WizardStepMap insertSteps = new WizardStepMap();
            insertSteps.put((Object)SELECT_STEP_NAME, (Object)selectStep);
            insertSteps.put((Object)EDIT_STEP_NAME, (Object)editStep);
            this.insertWizard = new Wizard(Strings.INSTANCE.macroInsertDialogCaption(), new Image(Images.INSTANCE.macroInsert()));
            this.insertWizard.setProvider((WizardStepProvider)insertSteps);
            this.insertWizard.addWizardListener((WizardListener)this);
        }
        return this.insertWizard;
    }

    public void destroy() {
        if (this.editWizard != null) {
            this.editWizard.removeWizardListener((WizardListener)this);
            this.editWizard.onDirection(NavigationListener.NavigationDirection.CANCEL);
            this.editWizard = null;
        }
        if (this.insertWizard != null) {
            this.insertWizard.removeWizardListener((WizardListener)this);
            this.insertWizard.onDirection(NavigationListener.NavigationDirection.CANCEL);
            this.insertWizard = null;
        }
    }
}

